/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.vo.FlowActionVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantFlowActionExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantFlowActionExServiceImpl
implements ITenantFlowActionExService {
    private static final Logger log = LoggerFactory.getLogger(TenantFlowActionExServiceImpl.class);
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private FlowActionRepository flowActionRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<FlowActionVo> getFlowActionVos(Long tenantAppId) {
        List<FlowAction> stdFlowActions = this.getStdFlowActions(tenantAppId);
        return this.flowActionRepository.getFlowActionVos(stdFlowActions).stream().map(o -> {
            o.getFlowAction().setId(o.getFlowAction().getPublishActionId());
            return o;
        }).collect(Collectors.toList());
    }

    @Override
    public List<FlowAction> getFlowActions(FlowAction flowAction) {
        List<Object> data = this.getStdFlowActions(flowAction.getAppId()).stream().map(o -> o.setId(o.getPublishActionId())).collect(Collectors.toList());
        if (null != flowAction.getActionType()) {
            data = data.stream().filter(r -> flowAction.getActionType().equals(r.getActionType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowAction.getActionCode())) {
            data = data.stream().filter(r -> null != r.getActionCode() && r.getActionCode().contains(flowAction.getActionCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowAction.getActionName())) {
            data = data.stream().filter(r -> null != r.getActionName() && r.getActionName().contains(flowAction.getActionName())).collect(Collectors.toList());
        }
        return data;
    }

    private List<FlowAction> getStdFlowActions(Long tenantAppId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantAppId);
        return this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), FlowAction.class);
    }
}

