/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.flow.mapstruct.FlowSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.flow.vo.FlowSettingVo;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantFlowSettingExService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantFlowSettingExServiceImpl
implements ITenantFlowSettingExService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<FlowSettingVo> getFlowVos(FlowSetting flowSetting) {
        AppRef appRef = this.appCustomValidator.validateAppRef(flowSetting.getAppId());
        List tenantPageVos = this.flowSettingRepository.getFlowSettings(flowSetting.getAppId()).stream().sorted(Comparator.comparing(FlowSetting::getId).reversed()).map(o -> {
            FlowSettingVo flowSettingExVo = FlowSettingStructMapper.MAPPER.toVo(o);
            flowSettingExVo.setAppCustomType(AppCustomType.TENANT.code());
            return flowSettingExVo;
        }).collect(Collectors.toList());
        List existStdFlowIds = tenantPageVos.stream().map(FlowSetting::getRefFlowId).collect(Collectors.toList());
        List stdFlows = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), FlowSetting.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        IdConvertUtil.convertFlowSettingVersionIdToUniId(stdFlows);
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.FLOW_SETTING).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List stdPageVos = stdFlows.stream().filter(o -> !existStdFlowIds.contains(o.getPublishFlowId())).map(o -> {
            FlowSettingVo flowSettingExVo = FlowSettingStructMapper.MAPPER.toVo(o);
            flowSettingExVo.setAppCustomType(AppCustomType.STANDARD.code());
            flowSettingExVo.setCustomDisabled(customDisabledIds.contains(o.getUniqueId()));
            return flowSettingExVo;
        }).collect(Collectors.toList());
        return ListUtils.union(tenantPageVos, stdPageVos);
    }

    @Override
    public ServiceResponse save(FlowSetting flowSetting) {
        if (null == flowSetting.getId()) {
            return ServiceResponse.fail((String)"\u6d41ID\u4e0d\u5b58\u5728");
        }
        App tenantApp = this.appCustomValidator.validateTenantApp(flowSetting.getAppId());
        Optional flowSettingOptional = this.flowSettingRepository.getFlowSetting(flowSetting.getId());
        if (flowSettingOptional.isPresent() && ((FlowSetting)flowSettingOptional.get()).getAppId().equals(flowSetting.getAppId())) {
            return this.update(flowSetting);
        }
        FlowSetting stdVersionFlow = this.appRefVersionMetadataService.getRefVersionFlow(flowSetting.getAppId(), flowSetting.getId()).orElse(null);
        if (null == stdVersionFlow) {
            return ServiceResponse.fail((String)"\u6807\u51c6\u6d41\u4e0d\u5b58\u5728");
        }
        this.validateStandardFlow(tenantApp, stdVersionFlow);
        FlowSetting tenantFlowSetting = FlowSettingStructMapper.MAPPER.clone(stdVersionFlow);
        tenantFlowSetting.setId(null);
        tenantFlowSetting.setUniqueId(null);
        tenantFlowSetting.setPublishFlowId(null);
        tenantFlowSetting.setFlowId(UUID.randomUUID().toString());
        tenantFlowSetting.setAppId(flowSetting.getAppId());
        tenantFlowSetting.setRefFlowId(stdVersionFlow.getPublishFlowId());
        tenantFlowSetting.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        tenantFlowSetting.setVersion("0.0.0");
        tenantFlowSetting.setCustomType(CustomType.CUSTOM.code());
        tenantFlowSetting.setTenantName(tenantApp.getTenantName());
        tenantFlowSetting.setTenantCode(tenantApp.getTenantCode());
        return this.flowSettingService.save((Object)tenantFlowSetting) ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public ServiceResponse update(FlowSetting tenantFlowSetting) {
        FlowSetting updateFlowSetting = new FlowSetting().setId(tenantFlowSetting.getId()).setName(tenantFlowSetting.getName()).setStatus(tenantFlowSetting.getStatus()).setFlowSetting(tenantFlowSetting.getFlowSetting()).setFlowSettingFront(tenantFlowSetting.getFlowSettingFront()).setRemark(tenantFlowSetting.getRemark()).setExtendAttribute(tenantFlowSetting.getExtendAttribute());
        return this.flowSettingService.updateById((Object)updateFlowSetting) ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public boolean removeFlowById(Long id) {
        return this.flowSettingService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FlowSetting::getId, (Object)id)).set(FlowSetting::getDeleteFlag, (Object)"0"));
    }

    private void validateStandardFlow(App tenantApp, FlowSetting stdVersionFlow) {
        this.flowSettingRepository.getFlowSettingWithValidate(stdVersionFlow.getId());
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionFlow.getUniqueId().longValue(), MetadataType.FLOW_SETTING);
        if (appRefSettingOptional.isPresent()) {
            throw new RuntimeException("\u6807\u51c6\u6d41\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        FlowSetting tenantFlow = (FlowSetting)this.flowSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getAppId, (Object)tenantApp.getId())).eq(FlowSetting::getRefFlowId, (Object)stdVersionFlow.getPublishFlowId())).eq(FlowSetting::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantFlow) {
            throw new RuntimeException("\u6d41\u79df\u6237\u5b9a\u5236\u5df2\u5b58\u5728");
        }
    }
}

