/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.view.util.PageBoSettingUtil;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantPageBoSettingExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IPageBoSettingService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantPageBoSettingExServiceImpl
implements ITenantPageBoSettingExService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private IPageBoSettingService pageBoSettingService;

    @Override
    public Boolean save(PageBoSetting pageBoSetting) {
        Long boId = this.getBoIdByPageIdAndBoCode(pageBoSetting.getPageId(), pageBoSetting.getBoCode());
        long sortPlace = this.getLastSortPlace(pageBoSetting.getPageId());
        pageBoSetting.setId(null);
        pageBoSetting.setUniqueId(null);
        pageBoSetting.setDisabledFlag("0");
        pageBoSetting.setVersion("1");
        pageBoSetting.setSortPlace(Long.valueOf(sortPlace + 1L));
        pageBoSetting.setBoId(boId);
        return this.pageBoSettingService.save((Object)pageBoSetting);
    }

    private long getLastSortPlace(Long pageId) {
        PageBoSetting checkPageBoSetting = new PageBoSetting();
        checkPageBoSetting.setPageId(pageId);
        checkPageBoSetting.setDeleteFlag("1");
        List pageBoSettings = this.pageBoSettingService.list((Wrapper)Wrappers.query((Object)checkPageBoSetting).orderByAsc((Object)"sort_place"));
        long sortPlace = PageBoSettingUtil.getLastSortPlace((List)pageBoSettings);
        if (!pageBoSettings.isEmpty()) {
            this.pageBoSettingService.updateBatchById((Collection)pageBoSettings, 10);
        }
        return sortPlace;
    }

    private Long getBoIdByPageIdAndBoCode(Long pageId, String boCode) {
        Optional ultPageOptional = this.ultPageRepository.getPage(pageId);
        if (!ultPageOptional.isPresent()) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u9875\u9762");
        }
        AppRef appRef = this.appCustomValidator.validateAppRef(((UltPage)ultPageOptional.get()).getAppId());
        List stdBos = this.boVersionQuery.getBos(appRef.getRefAppId(), appRef.getRefAppVersion());
        Optional<Bo> boOptional = stdBos.stream().filter(o -> o.getCode().equals(boCode)).findAny();
        if (!boOptional.isPresent()) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61");
        }
        return boOptional.get().getUniqueId();
    }
}

