/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpEnvStatus;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.vo.Auth;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltFormExVo;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltFormVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltFormExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.FormEnv;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.FormEnvMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltFormMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltFormService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantUltFormExServiceImpl
implements ITenantUltFormExService {
    @Autowired
    private UltFormMapper ultFormMapper;
    @Autowired
    private IUltFormService ultFormService;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private FormEnvMapper formEnvMapper;
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<UltFormExVo> getForms(UltForm ultForm) {
        AppRef appRef = this.appCustomValidator.validateAppRef(ultForm.getAppId());
        List tenantFormExVos = this.ultFormRepository.getForms(ultForm.getAppId()).stream().sorted(Comparator.comparing(UltForm::getId).reversed()).map(o -> {
            UltFormExVo ultFormExVo = UltFormStructMapper.MAPPER.toUltFormExVo(o);
            ultFormExVo.setAppCustomType(AppCustomType.TENANT.code());
            return ultFormExVo;
        }).collect(Collectors.toList());
        List existStdFormIds = tenantFormExVos.stream().map(UltForm::getRefFormId).collect(Collectors.toList());
        List stdForms = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), UltForm.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        IdConvertUtil.convertFormVersionIdToUniId(stdForms);
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.FORM).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List stdFormExVos = stdForms.stream().filter(o -> !existStdFormIds.contains(o.getPublishRefFormId())).map(o -> {
            UltFormExVo ultFormExVo = UltFormStructMapper.MAPPER.toUltFormExVo(o);
            ultFormExVo.setAppCustomType(AppCustomType.STANDARD.code());
            ultFormExVo.setCustomDisabled(customDisabledIds.contains(o.getUniqueId()));
            return ultFormExVo;
        }).collect(Collectors.toList());
        return ListUtils.union(tenantFormExVos, stdFormExVos);
    }

    @Override
    public ServiceResponse<Boolean> save(UltForm ultForm) {
        App tenantApp = this.appCustomValidator.validateTenantApp(ultForm.getAppId());
        UltForm stdVersionForm = this.appRefVersionMetadataService.getRefVersionForm(ultForm.getAppId(), ultForm.getId()).orElse(null);
        if (null == stdVersionForm) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6807\u51c6\u8868\u5355");
        }
        this.validateStandardForm(tenantApp, stdVersionForm);
        UltForm tenantUltForm = UltFormStructMapper.MAPPER.clone(stdVersionForm);
        tenantUltForm.setId(null);
        tenantUltForm.setUniqueId(null);
        tenantUltForm.setPublishRefFormId(null);
        tenantUltForm.setAppId(ultForm.getAppId());
        tenantUltForm.setRefFormId(stdVersionForm.getUniqueId());
        tenantUltForm.setPublishFlag(PfcpPublishFlag.UNPUBLISHED.code());
        tenantUltForm.setVersion("0.0.0");
        tenantUltForm.setCustomType(CustomType.CUSTOM.code());
        tenantUltForm.setTenantCode(tenantApp.getTenantCode());
        tenantUltForm.setTenantName(tenantApp.getTenantName());
        return ServiceResponse.success((String)"", (Object)this.ultFormService.save((Object)tenantUltForm));
    }

    @Override
    public ServiceResponse update(UltForm ultForm) {
        UltForm form = this.ultFormRepository.getFormWithValidate(ultForm.getId());
        if (!"0.0.0".equals(form.getVersion()) && (form.getCode() != null && !form.getCode().equals(ultForm.getCode()) || ultForm.getCode() != null && !ultForm.getCode().equals(form.getCode()))) {
            return ServiceResponse.fail((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u8868\u5355\u4ee3\u7801");
        }
        return ServiceResponse.success((String)"", (Object)this.ultFormMapper.updateById((Object)ultForm));
    }

    @Override
    public List<UltFormVo> initForms(Auth auth) {
        String envId = auth.getEnv();
        Long appId = auth.getAppId();
        String appCode = auth.getAppCode();
        if (StringUtils.isEmpty((CharSequence)appCode) && (appId == null || appId == 0L)) {
            return Lists.newArrayList();
        }
        FormEnv formEnv = new FormEnv();
        formEnv.setAppId(appId);
        formEnv.setEnvId(StringUtils.isEmpty((CharSequence)envId) ? "0" : envId);
        formEnv.setStatus(PfcpEnvStatus.UP.code());
        List formEnvs = this.formEnvMapper.selectList((Wrapper)Wrappers.query((Object)formEnv));
        ArrayList<UltFormVo> ultFormVos = new ArrayList<UltFormVo>();
        formEnvs.forEach(f -> {
            UltForm ultForm = (UltForm)this.ultFormMapper.selectById((Serializable)f.getFormId());
            UltFormVo ultFormVo = new UltFormVo();
            if (null != ultForm) {
                BeanUtils.copyProperties((Object)ultForm, (Object)ultFormVo);
                ultFormVos.add(ultFormVo);
            }
        });
        return ultFormVos;
    }

    @Override
    public boolean removeForm(Long id) {
        UltForm ultForm = this.ultFormRepository.getFormWithValidate(id);
        ultForm.setDeleteFlag("0");
        return this.ultFormService.updateById((Object)ultForm);
    }

    private void validateStandardForm(App tenantApp, UltForm stdVersionForm) {
        this.ultFormRepository.getFormWithValidate(stdVersionForm.getId());
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionForm.getUniqueId().longValue(), MetadataType.FORM);
        if (appRefSettingOptional.isPresent()) {
            throw new RuntimeException("\u6807\u51c6\u8868\u5355\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        UltForm tenantForm = (UltForm)this.ultFormService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getAppId, (Object)tenantApp.getId())).eq(UltForm::getRefFormId, (Object)stdVersionForm.getUniqueId())).eq(UltForm::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantForm) {
            throw new RuntimeException("\u79df\u6237\u8868\u5355\u5b9a\u5236\u5df2\u5b58\u5728");
        }
    }
}

