/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.PageBoSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltPageExVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltPageExService;
import com.xforceplus.ultraman.mybatisplus.core.api.XfPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.PageBoSettingMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltPageMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IPageBoSettingService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantUltPageExServiceImpl
implements ITenantUltPageExService {
    @Autowired
    private UltPageMapper ultPageMapper;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private IPageBoSettingService pageBoSettingService;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<UltPageExVo> getPages(UltPage ultPage) {
        AppRef appRef = this.appCustomValidator.validateAppRef(ultPage.getAppId());
        List tenantPageExVos = this.ultPageRepository.getPages(ultPage.getAppId()).stream().sorted(Comparator.comparing(UltPage::getId).reversed()).map(o -> {
            UltPageExVo ultPageExVo = UltPageStructMapper.MAPPER.toUltPageExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.TENANT.code());
            return ultPageExVo;
        }).collect(Collectors.toList());
        List existStdPageIds = tenantPageExVos.stream().map(UltPage::getRefPageId).collect(Collectors.toList());
        List stdPages = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), UltPage.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        IdConvertUtil.convertPageVersionIdToUniId(stdPages);
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.PAGE).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List stdPageExVos = stdPages.stream().filter(o -> !existStdPageIds.contains(o.getPublishRefPageId())).map(o -> {
            UltPageExVo ultPageExVo = UltPageStructMapper.MAPPER.toUltPageExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.STANDARD.code());
            ultPageExVo.setCustomDisabled(customDisabledIds.contains(o.getUniqueId()));
            return ultPageExVo;
        }).collect(Collectors.toList());
        return ListUtils.union(tenantPageExVos, stdPageExVos);
    }

    @Override
    public XfPage queryPagesByNC(XfPage page, UltPage ultPage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceResponse save(UltPage ultPage) {
        App tenantApp = this.appCustomValidator.validateTenantApp(ultPage.getAppId());
        UltPage stdVersionPage = this.appRefVersionMetadataService.getRefVersionPage(ultPage.getAppId(), ultPage.getId()).orElse(null);
        if (null == stdVersionPage) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6807\u51c6\u9875\u9762");
        }
        this.validateStandardPage(tenantApp, stdVersionPage);
        UltPage tenantPage = UltPageStructMapper.MAPPER.clone(stdVersionPage);
        tenantPage.setId(null);
        tenantPage.setUniqueId(null);
        tenantPage.setPublishRefPageId(null);
        tenantPage.setAppId(ultPage.getAppId());
        tenantPage.setRefPageId(stdVersionPage.getUniqueId());
        tenantPage.setPublishFlag(PfcpPublishFlag.UNPUBLISHED.code());
        tenantPage.setVersion("0.0.0");
        tenantPage.setCustomType(CustomType.CUSTOM.code());
        tenantPage.setTenantCode(tenantApp.getTenantCode());
        tenantPage.setTenantName(tenantApp.getTenantName());
        this.ultPageService.save((Object)tenantPage);
        List stdVersionPageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(stdVersionPage.getId());
        if (CollectionUtils.isNotEmpty((Collection)stdVersionPageBoSettings)) {
            for (PageBoSetting stdVersionPageBoSetting : stdVersionPageBoSettings) {
                PageBoSetting tenantPageBoSetting = PageBoSettingStructMapper.MAPPER.clone(stdVersionPageBoSetting);
                tenantPageBoSetting.setId(null);
                tenantPageBoSetting.setUniqueId(null);
                tenantPageBoSetting.setPageId(tenantPage.getId());
                this.pageBoSettingService.save((Object)tenantPageBoSetting);
            }
        }
        return ServiceResponse.success((String)"", (Object)true);
    }

    @Override
    public ServiceResponse update(UltPage ultPage) {
        UltPage page = this.ultPageRepository.getPageWithValidate(ultPage.getId());
        if (!"0.0.0".equals(page.getVersion()) && (page.getCode() != null && !page.getCode().equals(ultPage.getCode()) || ultPage.getCode() != null && !ultPage.getCode().equals(page.getCode()))) {
            return ServiceResponse.fail((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u9875\u9762\u4ee3\u7801");
        }
        return ServiceResponse.success((String)"", (Object)this.ultPageMapper.updateById((Object)ultPage));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removePage(Long id) {
        UltPage ultPage = this.ultPageRepository.getPageWithValidate(id);
        return this.removePageById(ultPage);
    }

    private boolean removePageById(UltPage ultPage) {
        ultPage.setDeleteFlag("0");
        boolean status = this.ultPageService.updateById((Object)ultPage);
        if (!status) {
            return false;
        }
        List pageBoSettings = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PageBoSetting::getPageId, (Object)ultPage.getId())).eq(PageBoSetting::getDeleteFlag, (Object)"1"));
        pageBoSettings.forEach(sett -> sett.setDeleteFlag("0"));
        if (!pageBoSettings.isEmpty()) {
            status = this.pageBoSettingService.updateBatchById((Collection)pageBoSettings, 10);
        }
        return status;
    }

    private void validateStandardPage(App tenantApp, UltPage stdVersionPage) {
        this.ultPageRepository.getPageWithValidate(stdVersionPage.getId());
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionPage.getUniqueId().longValue(), MetadataType.PAGE);
        if (appRefSettingOptional.isPresent()) {
            throw new RuntimeException("\u6807\u51c6\u9875\u9762\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        UltPage tenantPage = (UltPage)this.ultPageService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getAppId, (Object)tenantApp.getId())).eq(UltPage::getRefPageId, (Object)stdVersionPage.getUniqueId())).eq(UltPage::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantPage) {
            throw new RuntimeException("\u79df\u6237\u9875\u9762\u5b9a\u5236\u5df2\u5b58\u5728");
        }
    }
}

