/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltPageSettingExVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltPageSettingExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltPageSettingMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantUltPageSettingExServiceImpl
implements ITenantUltPageSettingExService {
    @Autowired
    private UltPageSettingMapper ultPageSettingMapper;
    @Autowired
    private IUltPageSettingService ultPageSettingService;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<UltPageSettingExVo> getPages(UltPageSetting ultPage) {
        AppRef appRef = this.appCustomValidator.validateAppRef(ultPage.getAppId());
        List tenantPageExVos = this.ultPageSettingRepository.getPageSettings(ultPage.getAppId()).stream().sorted(Comparator.comparing(UltPageSetting::getId).reversed()).map(o -> {
            UltPageSettingExVo ultPageExVo = UltPageSettingStructMapper.MAPPER.toUltPageSettingExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.TENANT.code());
            return ultPageExVo;
        }).collect(Collectors.toList());
        List existStdPageIds = tenantPageExVos.stream().map(UltPageSetting::getRefPageId).collect(Collectors.toList());
        List stdPages = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), UltPageSetting.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        IdConvertUtil.convertPageSettingVersionIdToUniId(stdPages);
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.PAGE).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List stdPageExVos = stdPages.stream().filter(o -> !existStdPageIds.contains(o.getPublishRefPageId())).map(o -> {
            UltPageSettingExVo ultPageExVo = UltPageSettingStructMapper.MAPPER.toUltPageSettingExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.STANDARD.code());
            ultPageExVo.setCustomDisabled(customDisabledIds.contains(o.getUniqueId()));
            return ultPageExVo;
        }).collect(Collectors.toList());
        return ListUtils.union(tenantPageExVos, stdPageExVos);
    }

    @Override
    public ServiceResponse save(UltPageSetting ultPage) {
        App tenantApp = this.appCustomValidator.validateTenantApp(ultPage.getAppId());
        UltPageSetting stdVersionPage = this.appRefVersionMetadataService.getRefVersionPageSetting(ultPage.getAppId(), ultPage.getId()).orElse(null);
        if (null == stdVersionPage) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6807\u51c6\u9875\u9762");
        }
        this.validateStandardPage(tenantApp, stdVersionPage);
        UltPageSetting tenantPage = UltPageSettingStructMapper.MAPPER.clone(stdVersionPage);
        tenantPage.setId(null);
        tenantPage.setUniqueId(null);
        tenantPage.setPublishRefPageId(null);
        tenantPage.setAppId(ultPage.getAppId());
        tenantPage.setRefPageId(stdVersionPage.getUniqueId());
        tenantPage.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        tenantPage.setVersion("0.0.0");
        tenantPage.setCustomType(CustomType.CUSTOM.code());
        tenantPage.setTenantCode(tenantApp.getTenantCode());
        tenantPage.setTenantName(tenantApp.getTenantName());
        this.ultPageSettingService.save((Object)tenantPage);
        return ServiceResponse.success((String)"", (Object)true);
    }

    @Override
    public ServiceResponse update(UltPageSetting ultPage) {
        UltPageSetting page = (UltPageSetting)this.ultPageSettingService.getById((Serializable)ultPage.getId());
        if (page == null) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u9875\u9762");
        }
        if (!"0.0.0".equals(page.getVersion()) && (page.getCode() != null && !page.getCode().equals(ultPage.getCode()) || ultPage.getCode() != null && !ultPage.getCode().equals(page.getCode()))) {
            return ServiceResponse.fail((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u9875\u9762\u4ee3\u7801");
        }
        return ServiceResponse.success((String)"", (Object)this.ultPageSettingMapper.updateById((Object)ultPage));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removePage(Long id) {
        UltPageSetting ultPage = (UltPageSetting)this.ultPageSettingService.getById((Serializable)id);
        if (null == ultPage) {
            return false;
        }
        ultPage.setDeleteFlag("0");
        return this.ultPageSettingService.updateById((Object)ultPage);
    }

    private void validateStandardPage(App tenantApp, UltPageSetting stdVersionPage) {
        UltPageSetting ultPage = (UltPageSetting)this.ultPageSettingService.getById((Serializable)stdVersionPage.getId());
        if (ultPage == null) {
            throw new RuntimeException("\u6807\u51c6\u9875\u9762\u4e0d\u5b58\u5728");
        }
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionPage.getUniqueId().longValue(), MetadataType.PAGE);
        if (appRefSettingOptional.isPresent()) {
            throw new RuntimeException("\u6807\u51c6\u9875\u9762\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        UltPageSetting tenantPage = (UltPageSetting)this.ultPageSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPageSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(UltPageSetting::getDeleteFlag, (Object)"1")).eq(UltPageSetting::getAppId, (Object)tenantApp.getId())).eq(UltPageSetting::getRefPageId, (Object)stdVersionPage.getUniqueId())).eq(UltPageSetting::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantPage) {
            throw new RuntimeException("\u79df\u6237\u9875\u9762\u5b9a\u5236\u5df2\u5b58\u5728");
        }
    }
}

