/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.BoVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(BoVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private BoVersionDiffQuery boVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionBo> lastVersionBos = this.boVersionDiffQuery.getVersionBos(appId, appVersionId);
        versionContent.setBos(lastVersionBos);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setBosDiff(VersionDiffExecutor.diff(versionContent.getBos(), this.boVersionDiffQuery.getUnPublishedBos(appId), VersionBo.class));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getBosDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap bosOfDiff = Maps.newHashMap();
                versionContent.getBos().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        bosOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setBosOfDiff(bosOfDiff);
                versionContent.setBos(null);
            }
        }
        this.publishCommonService.buildModuleChangeOpInfos(versionContent.getBosDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChange) {
        String rightVersion = null == rightVersionChange ? null : rightVersionChange.getResourceVersion();
        HashMap<String, VersionBo> leftVersionBos = null == leftAppVersionId ? Maps.newHashMap() : this.boVersionDiffQuery.getVersionBos(appId, leftAppVersionId);
        versionContent.setBos(leftVersionBos);
        versionContent.setBosDiff(VersionDiffExecutor.diff(leftVersionBos, this.boVersionDiffQuery.getPublishedVersionBos(appId, rightVersion), VersionBo.class));
        if (null != rightVersionChange) {
            this.publishCommonService.buildModuleChangeOpInfos(versionContent.getBosDiff(), rightVersionChange);
        }
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionBo> leftVersionBos = null == leftAppVersionId ? Maps.newHashMap() : this.boVersionDiffQuery.getVersionBos(appId, leftAppVersionId);
        return VersionDiffExecutor.diff(leftVersionBos, this.boVersionDiffQuery.getVersionBos(appId, rightAppVersionId), VersionBo.class);
    }
}

