/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.DictVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionDict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(DictVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private DictVersionDiffQuery dictVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionDict> versionDicts = this.dictVersionDiffQuery.getVersionDicts(appId, appVersionId);
        versionContent.setDicts(versionDicts);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setDictsDiff(VersionDiffExecutor.diff(versionContent.getDicts(), this.dictVersionDiffQuery.getUnPublishedDicts(appId), VersionDict.class));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getDictsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap dictsOfDiff = Maps.newHashMap();
                versionContent.getDicts().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        dictsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setDictsOfDiff(dictsOfDiff);
                versionContent.setDicts(null);
            }
        }
        this.publishCommonService.buildDictChangeOpInfos(versionContent.getDictsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChange) {
        String rightVersion = null == rightVersionChange ? null : rightVersionChange.getResourceVersion();
        HashMap<String, VersionDict> leftVersionDicts = null == leftAppVersionId ? Maps.newHashMap() : this.dictVersionDiffQuery.getVersionDicts(appId, leftAppVersionId);
        versionContent.setDicts(leftVersionDicts);
        versionContent.setDictsDiff(VersionDiffExecutor.diff(leftVersionDicts, this.dictVersionDiffQuery.getPublishedVersionDicts(appId, rightVersion), VersionDict.class));
        if (null == rightVersionChange) {
            this.publishCommonService.buildDictChangeOpInfos(versionContent.getDictsDiff(), appId, rightVersion);
        }
    }
}

