/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FlowActionVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionFlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowActionVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(FlowActionVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FlowActionVersionDiffQuery flowActionVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionFlowAction> versionItems = this.flowActionVersionDiffQuery.getVersionFlowActions(appId, appVersionId);
        versionContent.setFlowActions(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setFlowActionsDiff(VersionDiffExecutor.diff(versionContent.getFlowActions(), this.flowActionVersionDiffQuery.getUnPublishedFlowActions(appId), VersionFlowAction.class));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getFlowActionsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap flowActionsOfDiff = Maps.newHashMap();
                versionContent.getFlowActions().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        flowActionsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setFlowActionsOfDiff(flowActionsOfDiff);
                versionContent.setFlowActions(null);
            }
        }
        this.publishCommonService.buildFlowActionChangeOpInfos(versionContent.getFlowActionsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChange) {
        String rightVersion = null == rightVersionChange ? null : rightVersionChange.getResourceVersion();
        HashMap<String, VersionFlowAction> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.flowActionVersionDiffQuery.getVersionFlowActions(appId, leftAppVersionId);
        versionContent.setFlowActions(leftVersionItems);
        versionContent.setFlowActionsDiff(VersionDiffExecutor.diff(leftVersionItems, this.flowActionVersionDiffQuery.getPublishedVersionFlowActions(appId, rightVersion), VersionFlowAction.class));
        if (null != rightVersionChange) {
            this.publishCommonService.buildFlowActionChangeOpInfos(versionContent.getFlowActionsDiff(), appId, rightVersionChange.getResourceVersion());
        }
    }
}

