/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FlowSettingVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionFlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(FlowSettingVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FlowSettingVersionDiffQuery flowSettingVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionFlowSetting> versionItems = this.flowSettingVersionDiffQuery.getVersionFlowSettings(appId, appVersionId);
        versionContent.setFlowSettings(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setFlowSettingsDiff(this.diffEntry(versionContent.getFlowSettings(), this.flowSettingVersionDiffQuery.getUnPublishedFlowSettings(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getFlowSettingsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap flowSettingsOfDiff = Maps.newHashMap();
                versionContent.getFlowSettings().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        flowSettingsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setFlowSettingsOfDiff(flowSettingsOfDiff);
                versionContent.setFlowSettings(null);
            }
        }
        this.publishCommonService.buildFlowSettingChangeOpInfos(versionContent.getFlowSettingsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        HashMap<String, VersionFlowSetting> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.flowSettingVersionDiffQuery.getVersionFlowSettings(appId, leftAppVersionId);
        versionContent.setFlowSettings(leftVersionItems);
        versionContent.setFlowSettingsDiff(VersionDiffExecutor.diff(leftVersionItems, this.flowSettingVersionDiffQuery.getPublishedVersionFlowSettings(appId, rightVersionChgs), VersionFlowSetting.class));
        this.publishCommonService.buildFlowSettingChangeOpInfos(versionContent.getFlowSettingsDiff(), rightVersionChgs);
    }

    public List<ChangedItem> diffEntry(Map<String, VersionFlowSetting> lastVersionFlowSettings, Map<String, VersionFlowSetting> newestFlowSettings) {
        HashSet result = Sets.newHashSet();
        result.addAll(lastVersionFlowSettings.keySet());
        result.addAll(newestFlowSettings.keySet());
        return result.parallelStream().map(code -> {
            HashMap lastVersionFss = Maps.newHashMap();
            if (lastVersionFlowSettings.containsKey(code)) {
                lastVersionFss.put(code, lastVersionFlowSettings.get(code));
            }
            HashMap newestFss = Maps.newHashMap();
            if (newestFlowSettings.containsKey(code)) {
                newestFss.put(code, newestFlowSettings.get(code));
            }
            return VersionDiffExecutor.diff(lastVersionFss, newestFss, VersionFlowSetting.class);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

