/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FormVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionForm;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(FormVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FormVersionDiffQuery formVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionForm> versionItems = this.formVersionDiffQuery.getVersionForms(appId, appVersionId);
        versionContent.setForms(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setFormsDiff(this.diffEntry(versionContent.getForms(), this.formVersionDiffQuery.getUnPublishedForms(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getFormsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap formsOfDiff = Maps.newHashMap();
                versionContent.getForms().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        formsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setFormsOfDiff(formsOfDiff);
                versionContent.setForms(null);
            }
        }
        this.publishCommonService.buildFormChangeOpInfos(versionContent.getFormsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        HashMap<String, VersionForm> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.formVersionDiffQuery.getVersionForms(appId, leftAppVersionId);
        versionContent.setForms(leftVersionItems);
        versionContent.setFormsDiff(VersionDiffExecutor.diff(leftVersionItems, this.formVersionDiffQuery.getPublishedVersionForms(appId, rightVersionChgs), VersionForm.class));
        this.publishCommonService.buildFormChangeOpInfos(versionContent.getFormsDiff(), rightVersionChgs);
    }

    public List<ChangedItem> diffEntry(Map<String, VersionForm> lastVersionForms, Map<String, VersionForm> newestForms) {
        HashSet result = Sets.newHashSet();
        result.addAll(lastVersionForms.keySet());
        result.addAll(newestForms.keySet());
        return result.parallelStream().map(code -> {
            HashMap lastVersionPs = Maps.newHashMap();
            if (lastVersionForms.containsKey(code)) {
                lastVersionPs.put(code, lastVersionForms.get(code));
            }
            HashMap newestPs = Maps.newHashMap();
            if (newestForms.containsKey(code)) {
                newestPs.put(code, newestForms.get(code));
            }
            return VersionDiffExecutor.diff(lastVersionPs, newestPs, VersionForm.class);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

