/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.PageVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPage;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPageBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.PageBoSettingMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.PageBoSetting;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(PageVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private PageVersionDiffQuery pageVersionDiffQuery;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionPage> versionItems = this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, appVersionId);
        versionContent.setPages(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            log.debug("start all page diff, appId {} versionId {}", (Object)appId, (Object)appVersionId);
            versionContent.setPagesDiff(this.diffEntry(versionContent.getPages(), this.pageVersionDiffQuery.getUnPublishedPagesNoSetting(appId)));
            log.debug("finish all page diff, appId {} versionId {}", (Object)appId, (Object)appVersionId);
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getPagesDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap pagesOfDiff = Maps.newHashMap();
                versionContent.getPages().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        pagesOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setPagesOfDiff(pagesOfDiff);
                versionContent.setPages(null);
            }
        }
        log.debug("start buildPageChangeOpInfos, appId {} versionId {}", (Object)appId, (Object)appVersionId);
        this.publishCommonService.buildPageChangeOpInfos(versionContent.getPagesDiff());
        log.debug("finish buildPageChangeOpInfos, appId {} versionId {}", (Object)appId, (Object)appVersionId);
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        HashMap<String, VersionPage> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.pageVersionDiffQuery.getVersionPages(appId, leftAppVersionId);
        versionContent.setPages(leftVersionItems);
        versionContent.setPagesDiff(VersionDiffExecutor.diff(leftVersionItems, this.pageVersionDiffQuery.getPublishedVersionPages(appId, rightVersionChgs), VersionPage.class));
        this.publishCommonService.buildPageChangeOpInfos(versionContent.getPagesDiff(), rightVersionChgs);
    }

    public List<ChangedItem> diff(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages) {
        List<ChangedItem> changedItems;
        if (lastVersionPages.isEmpty() && !newestPages.isEmpty()) {
            newestPages.values().forEach(p -> this.getPageBoSetting((VersionPage)p));
            changedItems = newestPages.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.ADD.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else if (!lastVersionPages.isEmpty() && newestPages.isEmpty()) {
            lastVersionPages.values().forEach(p -> this.getPageBoSetting((VersionPage)p));
            changedItems = lastVersionPages.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.REMOVE.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else {
            this.getPageBoSetting(lastVersionPages, newestPages);
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            try {
                String pageIdStr = (String)lastVersionPages.keySet().stream().findAny().get();
                log.debug("start readTree left, page {}", (Object)pageIdStr);
                JsonNode left = objectMapper.readTree(JSON.toJSONString(lastVersionPages, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero}));
                log.debug("finish readTree left, page {}", (Object)pageIdStr);
                log.debug("start readTree right, page {}", (Object)pageIdStr);
                JsonNode right = objectMapper.readTree(JSON.toJSONString(newestPages, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero}));
                log.debug("finish readTree right, page {}", (Object)pageIdStr);
                log.debug("start diff, page {}", (Object)pageIdStr);
                JsonNode patch = JsonDiff.asJson((JsonNode)left, (JsonNode)right, (EnumSet)flags);
                log.debug("finish diff, page {}", (Object)pageIdStr);
                log.debug("start changedItems, page {}", (Object)pageIdStr);
                Iterable itor = () -> patch.iterator();
                changedItems = StreamSupport.stream(itor.spliterator(), false).map(ele -> (ChangedItem)JSON.parseObject((String)ele.toString(), ChangedItem.class)).collect(Collectors.toList());
                log.debug("finish changedItems, page {}", (Object)pageIdStr);
            }
            catch (JsonProcessingException e) {
                log.error("Json \u5904\u7406\u5931\u8d25", (Throwable)e);
                return Lists.newArrayList();
            }
        }
        return changedItems;
    }

    public List<ChangedItem> diffEntry(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages) {
        HashSet result = Sets.newHashSet();
        result.addAll(lastVersionPages.keySet());
        result.addAll(newestPages.keySet());
        return result.stream().map(code -> {
            HashMap lastVersionPs = Maps.newHashMap();
            if (lastVersionPages.containsKey(code)) {
                lastVersionPs.put(code, lastVersionPages.get(code));
            }
            HashMap newestPs = Maps.newHashMap();
            if (newestPages.containsKey(code)) {
                newestPs.put(code, newestPages.get(code));
            }
            return this.diff(lastVersionPs, newestPs);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void getPageBoSetting(VersionPage versionPage) {
        List originIds = versionPage.getPageBoSettings().values().stream().map(VersionPageBo::getOriginId).collect(Collectors.toList());
        HashMap pageBoSettingMap = originIds.isEmpty() ? Maps.newHashMap() : this.pageBoSettingMapper.selectList((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{PageBoSetting::getId, PageBoSetting::getSetting}).in(PageBoSetting::getId, originIds)).stream().collect(Collectors.toMap(PageBoSetting::getId, Function.identity()));
        versionPage.getPageBoSettings().values().forEach(versionPageBo -> {
            Optional.ofNullable(pageBoSettingMap.get(versionPageBo.getOriginId())).ifPresent(pageBoSetting -> versionPageBo.setSetting(JSON.parse((String)pageBoSetting.getSetting())));
            this.clearVersionCommonInfo((VersionPageBo)versionPageBo);
        });
    }

    private void clearVersionCommonInfo(VersionPageBo versionPageBo) {
        versionPageBo.setOriginId(null);
        versionPageBo.setUpdateTime(null);
    }

    private void getPageBoSetting(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages) {
        VersionPage lastVersionPage = lastVersionPages.values().stream().findAny().get();
        VersionPage newestPage = newestPages.values().stream().findAny().get();
        List<Object> settingIds = Lists.newArrayList();
        settingIds.addAll(lastVersionPage.getPageBoSettings().values().stream().map(VersionPageBo::getId).collect(Collectors.toList()));
        settingIds.addAll(newestPage.getPageBoSettings().values().stream().map(VersionPageBo::getId).collect(Collectors.toList()));
        settingIds = settingIds.stream().distinct().collect(Collectors.toList());
        log.debug("start get setting, page {} setting count old:{} new:{}", new Object[]{lastVersionPage.getId(), lastVersionPage.getPageBoSettings().size(), newestPage.getPageBoSettings().size()});
        settingIds.forEach(settingId -> {
            Optional<VersionPageBo> lOptl = lastVersionPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            Optional<VersionPageBo> nOptl = newestPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            if (lOptl.isPresent() && !nOptl.isPresent()) {
                lOptl.get().setSetting(JSON.parse((String)this.getSetting(lOptl.get().getOriginId())));
            } else if (!lOptl.isPresent() && nOptl.isPresent()) {
                nOptl.get().setSetting(JSON.parse((String)this.getSetting(nOptl.get().getOriginId())));
            } else if (lOptl.isPresent() && nOptl.isPresent() && (null == lOptl.get().getUpdateTime() || null == nOptl.get().getUpdateTime() || !lOptl.get().getUpdateTime().equals(nOptl.get().getUpdateTime()))) {
                lOptl.get().setSetting(JSON.parse((String)this.getSetting(lOptl.get().getOriginId())));
                nOptl.get().setSetting(JSON.parse((String)this.getSetting(nOptl.get().getOriginId())));
            }
            lOptl.ifPresent(pageBoSetting -> this.clearVersionCommonInfo((VersionPageBo)pageBoSetting));
            nOptl.ifPresent(pageBoSetting -> this.clearVersionCommonInfo((VersionPageBo)pageBoSetting));
        });
        log.debug("finish get setting, page {} setting count old:{} new:{}", new Object[]{lastVersionPage.getId(), lastVersionPage.getPageBoSettings().size(), newestPage.getPageBoSettings().size()});
    }

    private String getSetting(Long originId) {
        PageBoSetting pageBoSetting = (PageBoSetting)this.pageBoSettingMapper.selectOne((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{PageBoSetting::getSetting}).eq(PageBoSetting::getId, (Object)originId));
        return pageBoSetting.getSetting();
    }
}

