/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.SdkSettingVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionSdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdkSettingVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(SdkSettingVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private SdkSettingVersionDiffQuery sdkSettingVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionSdkSetting> versionItems = this.sdkSettingVersionDiffQuery.getVersionSdkSettings(appId, appVersionId);
        versionContent.setSdkSettings(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setSdkSettingsDiff(this.diffEntry(versionContent.getSdkSettings(), this.sdkSettingVersionDiffQuery.getUnPublishedSdkSettings(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getSdkSettingsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap flowSettingsOfDiff = Maps.newHashMap();
                versionContent.getSdkSettings().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        flowSettingsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setSdkSettingsOfDiff(flowSettingsOfDiff);
                versionContent.setSdkSettings(null);
            }
        }
        this.publishCommonService.buildSdkSettingChangeOpInfos(versionContent.getSdkSettingsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg) {
        HashMap<String, VersionSdkSetting> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.sdkSettingVersionDiffQuery.getVersionSdkSettings(appId, leftAppVersionId);
        versionContent.setSdkSettings(leftVersionItems);
        String rightVersion = null == rightVersionChg ? null : rightVersionChg.getResourceVersion();
        versionContent.setSdkSettingsDiff(VersionDiffExecutor.diff(leftVersionItems, this.sdkSettingVersionDiffQuery.getPublishedVersionSdkSettings(appId, rightVersion), VersionSdkSetting.class));
        this.publishCommonService.buildAppEventChangeOpInfos(versionContent.getAppEventsDiff(), appId, rightVersion);
    }

    public List<ChangedItem> diffEntry(Map<String, VersionSdkSetting> lastVersionSdkSettings, Map<String, VersionSdkSetting> newestSdkSettings) {
        HashSet result = Sets.newHashSet();
        result.addAll(lastVersionSdkSettings.keySet());
        result.addAll(newestSdkSettings.keySet());
        return result.parallelStream().map(code -> {
            HashMap lastVersionFss = Maps.newHashMap();
            if (lastVersionSdkSettings.containsKey(code)) {
                lastVersionFss.put(code, lastVersionSdkSettings.get(code));
            }
            HashMap newestFss = Maps.newHashMap();
            if (newestSdkSettings.containsKey(code)) {
                newestFss.put(code, newestSdkSettings.get(code));
            }
            return VersionDiffExecutor.diff(lastVersionFss, newestFss, VersionSdkSetting.class);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

