/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.version.diff.ApiVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.AppEventVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.BoVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.DictVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FlowActionVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FlowSettingVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FormVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.PageVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.RuleVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.SdkSettingVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.TagVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionDiffAggregator {
    private static final Logger log = LoggerFactory.getLogger(VersionDiffAggregator.class);
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private BoVersionDiffExecutor boVersionDiffExecutor;
    @Autowired
    private DictVersionDiffExecutor dictVersionDiffExecutor;
    @Autowired
    private PageVersionDiffExecutor pageVersionDiffExecutor;
    @Autowired
    private FormVersionDiffExecutor formVersionDiffExecutor;
    @Autowired
    private FlowActionVersionDiffExecutor flowActionVersionDiffExecutor;
    @Autowired
    private FlowSettingVersionDiffExecutor flowSettingVersionDiffExecutor;
    @Autowired
    private ApiVersionDiffExecutor apiVersionDiffExecutor;
    @Autowired
    private RuleVersionDiffExecutor ruleVersionDiffExecutor;
    @Autowired
    private TagVersionDiffExecutor tagVersionDiffExecutor;
    @Autowired
    private AppEventVersionDiffExecutor appEventVersionDiffExecutor;
    @Autowired
    private SdkSettingVersionDiffExecutor sdkSettingVersionDiffExecutor;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    public VersionContent executeDiff(Long appId, AppVersion appVersion) {
        Long appVersionId = null == appVersion ? null : appVersion.getId();
        VersionContent versionContent = new VersionContent();
        List<Supplier<Boolean>> suppliers = Arrays.asList(() -> {
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        });
        this.asyncExec(suppliers);
        return versionContent;
    }

    public VersionContent executeDiff(Long appId, AppVersion appVersion, String resourceType, String retDataType) {
        Long appVersionId;
        long startTime = System.currentTimeMillis();
        Long l = appVersionId = null == appVersion ? null : appVersion.getId();
        if (RetDataType.META.code().equals(retDataType)) {
            return this.metadataVersionQuery.getVersionMeta(appId, appVersionId, resourceType);
        }
        VersionContent versionContent = new VersionContent();
        if (ResourceType.BO.code().equals(resourceType)) {
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.DICT.code().equals(resourceType)) {
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.PAGE.code().equals(resourceType)) {
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.FORM.code().equals(resourceType)) {
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.FLOW_ACTION.code().equals(resourceType)) {
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.FLOW_SETTING.code().equals(resourceType)) {
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.API.code().equals(resourceType)) {
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.RULE.code().equals(resourceType)) {
            this.ruleVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.TAG.code().equals(resourceType)) {
            this.tagVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.APP_EVENT.code().equals(resourceType)) {
            this.appEventVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (ResourceType.SDK_SETTING.code().equals(resourceType)) {
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else {
            log.error("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8eBO,DICT,PAGE,FORM,FLOW_ACTION,FLOW_SETTING,API,RULE,TAG\u5176\u4e2d\u4e4b\u4e00");
        }
        log.debug("execution diff time: {}", (Object)((System.currentTimeMillis() - startTime) / 1000L + "ms"));
        return versionContent;
    }

    public ServiceResponse executeDiff(Long appId, Long leftVersionId, Long rightVersionId) {
        if (leftVersionId != null && leftVersionId.equals(rightVersionId)) {
            return ServiceResponse.success((String)"", (Object)new VersionContent());
        }
        AppVersion leftAppVersion = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)leftVersionId), false);
        AppVersion rightAppVersion = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)rightVersionId)).eq(AppVersion::getDeleteFlag, (Object)"1"), false);
        if (rightAppVersion == null) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u88ab\u6bd4\u8f83\u7248\u672c\u4fe1\u606f");
        }
        List rightVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)rightAppVersion.getId())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
        if (rightVersionChanges.isEmpty()) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u88ab\u6bd4\u8f83\u7684\u7248\u672c\u5dee\u5f02\u4fe1\u606f");
        }
        VersionContent versionContent = new VersionContent();
        List<Supplier<Boolean>> suppliers = Arrays.asList(() -> {
            Optional<AppVersionChange> rightBoChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.BO.code().equals(vc.getResourceType())).findAny();
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightBoChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightDictChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.DICT.code().equals(vc.getResourceType())).findAny();
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightDictChangeOptl.orElse(null));
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> ResourceType.PAGE.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> ResourceType.FORM.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            Optional<AppVersionChange> rightActionChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.FLOW_ACTION.code().equals(vc.getResourceType())).findAny();
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightActionChangeOptl.orElse(null));
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> ResourceType.FLOW_SETTING.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            Optional<AppVersionChange> rightApiChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.API.code().equals(vc.getResourceType())).findAny();
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightApiChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.RULE.code().equals(vc.getResourceType())).findAny();
            this.ruleVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.TAG.code().equals(vc.getResourceType())).findAny();
            this.tagVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.APP_EVENT.code().equals(vc.getResourceType())).findAny();
            this.appEventVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> ResourceType.SDK_SETTING.code().equals(vc.getResourceType())).findAny();
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        });
        this.asyncExec(suppliers);
        log.debug("{} {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId, (Object)rightAppVersion.getVersion());
        versionContent.setAppVersionExist(leftAppVersion != null);
        versionContent.setRemark(rightAppVersion.getRemark());
        versionContent.setAppVersions(this.metadataVersionQuery.getAppVersions(appId, leftVersionId, rightVersionId));
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    public List<ChangedItem> diffBos(Map<String, VersionBo> lastVersionBos, Map<String, VersionBo> newestBos) {
        return VersionDiffExecutor.diff(lastVersionBos, newestBos, VersionBo.class);
    }

    private void asyncExec(List<Supplier<Boolean>> suppliers) {
        ExecutorService executor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(6));
        List<CompletableFuture> diffTasks = suppliers.stream().map(supplier -> CompletableFuture.supplyAsync(supplier, executor)).collect(Collectors.toList());
        CompletableFuture<Void> allTasksFuture = CompletableFuture.allOf(diffTasks.toArray(new CompletableFuture[0]));
        try {
            allTasksFuture.join();
        }
        catch (Exception e) {
            log.error("\u5dee\u5f02\u5bf9\u6bd4\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

