/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(VersionDiffExecutor.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> List<ChangedItem> diff(Map<String, T> lastVersionItems, Map<String, T> newestItems, Class<T> clazz) {
        List<ChangedItem> changedItems;
        if (lastVersionItems.isEmpty() && !newestItems.isEmpty()) {
            changedItems = newestItems.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.ADD.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else if (!lastVersionItems.isEmpty() && newestItems.isEmpty()) {
            changedItems = lastVersionItems.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.REMOVE.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else {
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            try {
                JsonNode left = objectMapper.readTree(JSON.toJSONString(lastVersionItems, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero}));
                JsonNode right = objectMapper.readTree(JSON.toJSONString(newestItems, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero}));
                JsonNode patch = JsonDiff.asJson((JsonNode)left, (JsonNode)right, (EnumSet)flags);
                Iterable itor = () -> patch.iterator();
                changedItems = StreamSupport.stream(itor.spliterator(), false).map(ele -> (ChangedItem)JSON.parseObject((String)ele.toString(), ChangedItem.class)).collect(Collectors.toList());
            }
            catch (JsonProcessingException e) {
                log.error("Json \u5904\u7406\u5931\u8d25", (Throwable)e);
                return Lists.newArrayList();
            }
        }
        return changedItems;
    }
}

