/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionApiStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IApisService apisService;

    public HashMap<String, VersionApi> getVersionApis(Long appId, Long appVersionId) {
        AppVersionChange versionChange;
        String version = null == appVersionId ? this.getLatestApiVersion(appId) : ((versionChange = (AppVersionChange)this.appVersionQuery.getAppVersionChange(appVersionId, ResourceType.API).orElse(null)) == null ? null : versionChange.getResourceVersion());
        return null == version ? Maps.newHashMap() : (HashMap)this.getPublishedVersionApis(appId, version);
    }

    public String getLatestApiVersion(Long appId) {
        List uApis = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).orderByDesc(Apis::getCreateTime));
        return this.getLatestApiVersion(appId, uApis);
    }

    public String getLatestApiVersion(Long appId, List<Apis> uApis) {
        if (uApis.isEmpty()) {
            List pApis = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(Apis::getId));
            return pApis.isEmpty() ? null : ((Apis)pApis.get(0)).getVersion();
        }
        return uApis.get(0).getVersion();
    }

    public Map<String, VersionApi> getUnPublishedApis(Long appId) {
        List apis = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (apis.isEmpty()) {
            return Maps.newHashMap();
        }
        return apis.stream().map(VersionApiStructMapper.MAPPER::toVersionApi).collect(Collectors.toMap(api -> String.valueOf(api.getId()), Functions.identity()));
    }

    public Map<String, VersionApi> getPublishedVersionApis(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List apis = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getVersion, (Object)version));
        if (apis.isEmpty()) {
            return Maps.newHashMap();
        }
        return apis.stream().map(VersionApiStructMapper.MAPPER::toVersionApi).collect(Collectors.toMap(api -> String.valueOf(api.getId()), Functions.identity()));
    }
}

