/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoApiType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapper.VersionBoFieldExMapper;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionBoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoApi;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoApiDetail;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApiDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiDetailService;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import io.vavr.Tuple6;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(BoVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private IBoApiDetailService boApiDetailService;
    @Autowired
    private VersionBoFieldExMapper versionBoFieldExMapper;

    public HashMap<String, VersionBo> getVersionBos(Long appId, Long appVersionId) {
        String version;
        if (null == appVersionId) {
            Optional mOptl = this.defaultModuleService.getModule(appId.longValue());
            version = mOptl.isPresent() ? ((Module)mOptl.get()).getVersion() : null;
        } else {
            AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appVersionId, ResourceType.BO).orElse(null);
            String string = version = null == versionChange ? null : versionChange.getResourceVersion();
        }
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        HashMap publishedVersionBoMap = (HashMap)this.getPublishedVersionBos(appId, version);
        return publishedVersionBoMap;
    }

    public Map<String, VersionBo> getVersionBos(Long moduleId, PublishFlag publishFlag) {
        HashMap result = Maps.newHashMap();
        List boIds = this.defaultModuleService.getBoIds(moduleId);
        if (boIds.isEmpty()) {
            return result;
        }
        Tuple6 boTuple = this.commonService.getBoInfoTuple(boIds);
        Map<Long, Long> boIdMap = PublishFlag.PUBLISHED.equals((Object)publishFlag) ? ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId)) : ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getId));
        Map<Long, Long> boFieldIdMap = PublishFlag.PUBLISHED.equals((Object)publishFlag) ? ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getPublishFieldId)) : ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getId));
        ((List)boTuple._1).forEach(bo -> {
            if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                bo.setParentBoId((Long)boIdMap.get(bo.getParentBoId()));
                bo.setRefBoId((Long)boIdMap.get(bo.getRefBoId()));
                bo.setSyncBoId((Long)boIdMap.get(bo.getSyncBoId()));
            }
            VersionBo versionBo = VersionBoStructMapper.MAPPER.toVersionBo((Bo)bo);
            Optional.ofNullable(((Map)boTuple._2).get(bo.getId())).ifPresent(boApis -> {
                List boApiIds = boApis.stream().filter(boApi -> BoApiType.EXTERNAL.code().equals(boApi.getApiType())).map(BoApi::getId).collect(Collectors.toList());
                HashMap boApiDetailMap = boApiIds.isEmpty() ? Maps.newHashMap() : this.boApiDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoApiDetail::getBoApiId, boApiIds)).orderByAsc(BoApiDetail::getCreateTime)).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId));
                boApis.forEach(boApi -> boApi.setBoId((Long)boIdMap.get(boApi.getBoId())));
                versionBo.setBoApis(boApis.stream().map(boApi -> {
                    VersionBoApi versionBoApi = VersionBoStructMapper.MAPPER.toVersionBoApi((BoApi)boApi);
                    versionBoApi.setDetails(Optional.ofNullable(boApiDetailMap.get(boApi.getId())).map(boApiDetails -> boApiDetails.stream().map(boApiDetail -> new VersionBoApiDetail().setMappingRule(boApiDetail.getMappingRule()).setMappingType(boApiDetail.getMappingType())).collect(Collectors.toMap(d -> String.valueOf(d.getMappingType()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoApi;
                }).collect(Collectors.toMap(VersionBoApi::getCode, Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._3).get(bo.getId())).ifPresent(boRelationships -> {
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    boRelationships.forEach(boRel -> {
                        boRel.setBoField(boRel.getBoField() == null ? null : (Long)boFieldIdMap.get(boRel.getBoField()));
                        boRel.setJoinField(boRel.getJoinField() == null ? null : (Long)boFieldIdMap.get(boRel.getJoinField()));
                        boRel.setBoId((Long)boIdMap.get(boRel.getBoId()));
                        boRel.setJoinBoId((Long)boIdMap.get(boRel.getJoinBoId()));
                    });
                }
                versionBo.setBoRelationships(boRelationships.stream().map(VersionBoStructMapper.MAPPER::toVersionBoRelationship).collect(Collectors.toMap(vBoRel -> String.valueOf(vBoRel.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._4).get(bo.getId())).ifPresent(boIndexes -> {
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    boIndexes.forEach(boIdx -> boIdx.setBoId((Long)boIdMap.get(boIdx.getBoId())));
                }
                versionBo.setBoIndexes(boIndexes.stream().map(VersionBoStructMapper.MAPPER::toVersionBoIndex).collect(Collectors.toMap(v -> String.valueOf(v.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._5).get(bo.getId())).ifPresent(boFields -> {
                List<VersionBoField> versionBoFields = this.versionBoFieldExMapper.getVersionBoFieldList(boFields.stream().map(BoField::getId).collect(Collectors.toList()));
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    versionBoFields.forEach(vBoField -> vBoField.setBoId((Long)boIdMap.get(vBoField.getBoId())));
                }
                versionBoFields.forEach(vBoField -> {
                    if (FieldType.LOOKUP.code().equals(vBoField.getType())) {
                        vBoField.setLookupFieldId(vBoField.getLookupFieldId() == null ? null : (Long)boFieldIdMap.get(vBoField.getLookupFieldId()));
                    } else if (FieldType.AGGREGATION.code().equals(vBoField.getType())) {
                        vBoField.setAggregationFieldId(vBoField.getAggregationFieldId() == null ? null : (Long)boFieldIdMap.get(vBoField.getAggregationFieldId()));
                    }
                });
                versionBo.setBoFields(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._6).get(bo.getId())).ifPresent(items -> {
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    items.forEach(item -> item.setBoId((Long)boIdMap.get(item.getBoId())));
                }
                versionBo.setBoDataRules(items.stream().map(VersionBoStructMapper.MAPPER::toVersionBoDataRule).collect(Collectors.toMap(o -> String.valueOf(o.getId()), Functions.identity())));
            });
            result.put(String.valueOf(versionBo.getId()), versionBo);
        });
        return result;
    }

    public Map<String, VersionBo> getUnPublishedBos(Long appId) {
        Optional moduleOptional = this.defaultModuleService.getModule(appId.longValue());
        return moduleOptional.isPresent() ? this.getVersionBos(((Module)moduleOptional.get()).getId(), PublishFlag.UNPUBLISHED) : Maps.newHashMap();
    }

    public Map<String, VersionBo> getPublishedVersionBos(Long appId, String moduleVersion) {
        HashMap result = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)moduleVersion)) {
            return result;
        }
        Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), moduleVersion);
        if (!moduleOptl.isPresent()) {
            return result;
        }
        List boIds = this.defaultModuleService.getBoIds(((Module)moduleOptl.get()).getId());
        if (boIds.isEmpty()) {
            return result;
        }
        Tuple6 boTuple = this.commonService.getBoInfoTuple(boIds);
        Map<Long, Long> boIdMap = ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        Map<Long, Long> boFieldIdMap = ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getPublishFieldId));
        return ((List)boTuple._1).stream().map(bo -> {
            bo.setParentBoId((Long)boIdMap.get(bo.getParentBoId())).setRefBoId((Long)boIdMap.get(bo.getRefBoId())).setSyncBoId((Long)boIdMap.get(bo.getSyncBoId()));
            VersionBo versionBo = VersionBoStructMapper.MAPPER.toVersionBo((Bo)bo);
            Optional.ofNullable(((Map)boTuple._2).get(bo.getId())).ifPresent(boApis -> {
                List boApiIds = boApis.stream().filter(boApi -> BoApiType.EXTERNAL.code().equals(boApi.getApiType())).map(BoApi::getId).collect(Collectors.toList());
                HashMap boApiDetailMap = boApiIds.isEmpty() ? Maps.newHashMap() : this.boApiDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoApiDetail::getBoApiId, boApiIds)).orderByAsc(BoApiDetail::getCreateTime)).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId));
                boApis.forEach(boApi -> boApi.setBoId((Long)boIdMap.get(boApi.getBoId())));
                versionBo.setBoApis(boApis.stream().map(boApi -> {
                    VersionBoApi versionBoApi = VersionBoStructMapper.MAPPER.toVersionBoApi((BoApi)boApi);
                    versionBoApi.setDetails(Optional.ofNullable(boApiDetailMap.get(boApi.getId())).map(boApiDetails -> boApiDetails.parallelStream().map(boApiDetail -> new VersionBoApiDetail().setMappingRule(boApiDetail.getMappingRule()).setMappingType(boApiDetail.getMappingType())).collect(Collectors.toMap(d -> String.valueOf(d.getMappingType()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoApi;
                }).collect(Collectors.toMap(VersionBoApi::getCode, Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._3).get(bo.getId())).ifPresent(boRelationships -> {
                boRelationships.forEach(boRel -> {
                    boRel.setBoField(boRel.getBoField() == null ? null : (Long)boFieldIdMap.get(boRel.getBoField()));
                    boRel.setJoinField(boRel.getJoinField() == null ? null : (Long)boFieldIdMap.get(boRel.getJoinField()));
                    boRel.setBoId((Long)boIdMap.get(boRel.getBoId()));
                    boRel.setJoinBoId((Long)boIdMap.get(boRel.getJoinBoId()));
                });
                versionBo.setBoRelationships(boRelationships.stream().map(VersionBoStructMapper.MAPPER::toVersionBoRelationship).collect(Collectors.toMap(vBoRel -> String.valueOf(vBoRel.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._4).get(bo.getId())).ifPresent(boIndexes -> {
                boIndexes.forEach(boIdx -> boIdx.setBoId((Long)boIdMap.get(boIdx.getBoId())));
                versionBo.setBoIndexes(boIndexes.stream().map(VersionBoStructMapper.MAPPER::toVersionBoIndex).collect(Collectors.toMap(v -> String.valueOf(v.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._5).get(bo.getId())).ifPresent(boFields -> {
                List<VersionBoField> versionBoFields = this.versionBoFieldExMapper.getVersionBoFieldList(boFields.stream().map(BoField::getId).collect(Collectors.toList()));
                versionBoFields.forEach(vBoField -> vBoField.setBoId((Long)boIdMap.get(vBoField.getBoId())));
                versionBoFields.forEach(vBoField -> {
                    if (FieldType.LOOKUP.code().equals(vBoField.getType())) {
                        vBoField.setLookupFieldId(vBoField.getLookupFieldId() == null ? null : (Long)boFieldIdMap.get(vBoField.getLookupFieldId()));
                    } else if (FieldType.AGGREGATION.code().equals(vBoField.getType())) {
                        vBoField.setAggregationFieldId(vBoField.getAggregationFieldId() == null ? null : (Long)boFieldIdMap.get(vBoField.getAggregationFieldId()));
                    }
                });
                versionBo.setBoFields(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._6).get(bo.getId())).ifPresent(items -> {
                items.forEach(item -> item.setBoId((Long)boIdMap.get(item.getBoId())));
                versionBo.setBoDataRules(items.stream().map(VersionBoStructMapper.MAPPER::toVersionBoDataRule).collect(Collectors.toMap(o -> String.valueOf(o.getId()), Functions.identity())));
            });
            return versionBo;
        }).collect(Collectors.toMap(versionBo -> String.valueOf(versionBo.getId()), Functions.identity()));
    }
}

