/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionDictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionDict;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionDictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IDictDetailService dictDetailService;

    public HashMap<String, VersionDict> getVersionDicts(Long appId, Long appVersionId) {
        AppVersionChange dictVersionChange;
        String version = null == appVersionId ? this.getLatestDictVersion(appId) : ((dictVersionChange = (AppVersionChange)this.appVersionQuery.getAppVersionChange(appVersionId, ResourceType.DICT).orElse(null)) == null ? null : dictVersionChange.getResourceVersion());
        return null == version ? Maps.newHashMap() : (HashMap)this.getPublishedVersionDicts(appId, version);
    }

    public String getLatestDictVersion(Long appId) {
        List uDicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(Dict::getPublishFlag)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        })).orderByDesc(Dict::getCreateTime));
        return this.getLatestDictVersion(appId, uDicts);
    }

    public String getLatestDictVersion(Long appId, List<Dict> uDicts) {
        if (uDicts.isEmpty()) {
            List pDicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(Dict::getId));
            return pDicts.isEmpty() ? null : ((Dict)pDicts.get(0)).getVersion();
        }
        return uDicts.get(0).getVersion();
    }

    public Map<String, VersionDict> getUnPublishedDicts(Long appId) {
        List dicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (dicts.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<DictDetail>> dictDetailsMap = this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(DictDetail::getDictId, (Collection)dicts.stream().map(Dict::getId).collect(Collectors.toList()))).eq(DictDetail::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        return dicts.stream().map(dict -> {
            VersionDict versionDict = VersionDictStructMapper.MAPPER.toVersionDict((Dict)dict);
            Optional.ofNullable(dictDetailsMap.get(dict.getId())).ifPresent(dictDetails -> versionDict.setDictDetails(dictDetails.stream().map(VersionDictStructMapper.MAPPER::toVersionDictDetail).collect(Collectors.toMap(VersionDictDetail::getCode, Functions.identity()))));
            return versionDict;
        }).collect(Collectors.toMap(dict -> String.valueOf(dict.getId()), Functions.identity()));
    }

    public Map<String, VersionDict> getPublishedVersionDicts(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List dicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Dict::getAppId, (Object)appId)).eq(Dict::getVersion, (Object)version));
        if (dicts.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<DictDetail>> dictDetailsMap = this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(DictDetail::getDictId, (Collection)dicts.stream().map(Dict::getId).collect(Collectors.toList()))).eq(DictDetail::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        return dicts.stream().map(dict -> {
            VersionDict versionDict = VersionDictStructMapper.MAPPER.toVersionDict((Dict)dict);
            Optional.ofNullable(dictDetailsMap.get(dict.getId())).ifPresent(dictDetails -> versionDict.setDictDetails(dictDetails.stream().map(VersionDictStructMapper.MAPPER::toVersionDictDetail).collect(Collectors.toMap(VersionDictDetail::getCode, Functions.identity()))));
            return versionDict;
        }).collect(Collectors.toMap(versionDict -> String.valueOf(versionDict.getId()), Functions.identity()));
    }
}

