/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionFlowStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionFlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionDiffQuery {
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;

    public HashMap<String, VersionFlowSetting> getVersionFlowSettings(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionFlowSettings(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, ResourceType.FLOW_SETTING);
        return (HashMap)this.getPublishedVersionFlowSettings(appId, versionChanges);
    }

    public Map<String, VersionFlowSetting> getLatestVersionFlowSettings(Long appId) {
        List flowSettings = this.flowSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(FlowSetting.class, field -> !field.getColumn().equals("flow_setting_front")).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(FlowSetting::getPublishFlag)).or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        }));
        if (flowSettings.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper flowSettingWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(FlowSetting.class, field -> !field.getColumn().equals("flow_setting_front")).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(FlowSetting::getDeleteFlag, (Object)"1")).and(w -> flowSettings.forEach(form -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(FlowSetting::getPublishFlowId, (Object)form.getId())).eq(FlowSetting::getVersion, (Object)form.getVersion());
        }));
        return flowSettings.isEmpty() ? Maps.newHashMap() : this.flowSettingService.list((Wrapper)flowSettingWrapper).stream().map(pFlowSetting -> {
            VersionFlowSetting versionFlowSetting = VersionFlowStructMapper.MAPPER.toVersionFlowSetting((FlowSetting)pFlowSetting);
            return versionFlowSetting;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionFlowSetting> getUnPublishedFlowSettings(Long appId) {
        List lists = this.flowSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(FlowSetting.class, field -> !field.getColumn().equals("flow_setting_front")).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(FlowSetting::getPublishFlag)).or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        }));
        Map<String, VersionFlowSetting> tmp = lists.stream().map(i -> {
            VersionFlowSetting v = new VersionFlowSetting();
            BeanUtils.copyProperties((Object)i, (Object)v);
            return v;
        }).collect(Collectors.toMap(flow -> String.valueOf(flow.getId()), Functions.identity()));
        return tmp;
    }

    public Map<String, VersionFlowSetting> getPublishedVersionFlowSettings(Long appId, List<AppVersionChange> flowSettingChanges) {
        List finalFlowSettingChanges = flowSettingChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (flowSettingChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(FlowSetting.class, field -> !field.getColumn().equals("flow_setting_front")).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalFlowSettingChanges.forEach(flowSettingChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlowId, (Object)flowSettingChange.getResourceId())).eq(FlowSetting::getVersion, (Object)flowSettingChange.getResourceVersion());
            });
        }));
        return this.flowSettingService.list((Wrapper)wrapper).stream().map(pFlowSetting -> {
            VersionFlowSetting versionFlowSetting = VersionFlowStructMapper.MAPPER.toVersionFlowSetting((FlowSetting)pFlowSetting);
            return versionFlowSetting;
        }).collect(Collectors.toMap(flowSetting -> String.valueOf(flowSetting.getId()), Functions.identity()));
    }

    public Map<String, VersionFlowSetting> getPublishedVersionFlowSettings(Long appId, AppVersion appVersion) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getDeleteFlag, (Object)"1")).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).le(AppVersion::getPublishTime, (Object)appVersion.getPublishTime())).orderByDesc(AppVersion::getPublishTime));
        if (appVersions.isEmpty()) {
            return Maps.newHashMap();
        }
        AppVersion lastAppVersion = (AppVersion)appVersions.get(0);
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(lastAppVersion.getId(), ResourceType.FLOW_SETTING);
        if (versionChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.getPublishedVersionFlowSettings(appId, versionChanges);
    }
}

