/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionUltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionForm;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltFormMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private UltFormMapper ultFormMapper;

    public HashMap<String, VersionForm> getVersionForms(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionForms(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, ResourceType.FORM);
        return (HashMap)this.getPublishedVersionForms(appId, versionChanges);
    }

    public Map<String, VersionForm> getLatestVersionForms(Long appId) {
        List ultForms = this.ultFormMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1"));
        if (ultForms.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper ultFormWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1")).and(w -> ultForms.forEach(form -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(UltForm::getPublishRefFormId, (Object)form.getId())).eq(UltForm::getVersion, (Object)form.getVersion());
        }));
        return ultForms.isEmpty() ? Maps.newHashMap() : this.ultFormMapper.selectList((Wrapper)ultFormWrapper).stream().map(pUltForm -> {
            VersionForm versionForm = VersionUltFormStructMapper.MAPPER.toVersionForm((UltForm)pUltForm);
            versionForm.setSetting(JSON.parse((String)pUltForm.getSetting()));
            return versionForm;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getUnPublishedForms(Long appId) {
        return this.ultFormMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1")).stream().map(ultForm -> {
            VersionForm versionForm = VersionUltFormStructMapper.MAPPER.toVersionForm((UltForm)ultForm);
            versionForm.setSetting(JSON.parse((String)ultForm.getSetting()));
            return versionForm;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getPublishedVersionForms(Long appId, List<AppVersionChange> formChanges) {
        List finalFormChanges = formChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalFormChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalFormChanges.forEach(formChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)formChange.getResourceId())).eq(UltForm::getVersion, (Object)formChange.getResourceVersion());
            });
        }));
        return this.ultFormMapper.selectList((Wrapper)wrapper).stream().map(pUltForm -> {
            VersionForm versionForm = VersionUltFormStructMapper.MAPPER.toVersionForm((UltForm)pUltForm);
            versionForm.setSetting(JSON.parse((String)pUltForm.getSetting()));
            return versionForm;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getPublishedVersionForms(Long appId, AppVersion appVersion) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getDeleteFlag, (Object)"1")).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).le(AppVersion::getPublishTime, (Object)appVersion.getPublishTime())).orderByDesc(AppVersion::getPublishTime));
        if (appVersions.isEmpty()) {
            return Maps.newHashMap();
        }
        AppVersion lastAppVersion = (AppVersion)appVersions.get(0);
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(lastAppVersion.getId(), ResourceType.FORM);
        if (versionChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.getPublishedVersionForms(appId, versionChanges);
    }
}

