/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionUltPageStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPage;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPageBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.PageBoSettingMapper;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltPageMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(PageVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    @Autowired
    private UltPageMapper ultPageMapper;

    public HashMap<String, VersionPage> getVersionPages(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionPages(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, ResourceType.PAGE);
        return versionChanges.isEmpty() ? Maps.newHashMap() : (HashMap)this.getPublishedVersionPages(appId, versionChanges);
    }

    public Map<String, VersionPage> getLatestVersionPages(Long appId) {
        ArrayList pUltPages;
        List ultPages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
        if (ultPages.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper ultPageWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1")).and(w -> ultPages.forEach(page -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(UltPage::getPublishRefPageId, (Object)page.getId())).eq(UltPage::getVersion, (Object)page.getVersion());
        }));
        List list = pUltPages = ultPages.isEmpty() ? Lists.newArrayList() : this.ultPageMapper.selectList((Wrapper)ultPageWrapper);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> new VersionPageBo().setId(pageBoSetting.getUniqueId()).setPageId(pUltPage.getPublishRefPageId()).setBoCode(pageBoSetting.getBoCode()).setBoName(pageBoSetting.getBoName()).setSortPlace(pageBoSetting.getSortPlace()).setRemark(pageBoSetting.getRemark()).setDisabledFlag(pageBoSetting.getDisabledFlag()).setSetting(JSON.parse((String)pageBoSetting.getSetting()))).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getUnPublishedPages(Long appId) {
        List ultPages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
        if (ultPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = ultPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> versionPageSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return ultPages.stream().map(ultPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)ultPage);
            Optional.ofNullable(versionPageSettingMap.get(versionPage.getId())).ifPresent(vPageSettings -> {
                Map<String, VersionPageBo> versionPageBos = vPageSettings.parallelStream().map(vPageSetting -> new VersionPageBo().setId(vPageSetting.getUniqueId()).setPageId(vPageSetting.getPageId()).setBoCode(vPageSetting.getBoCode()).setBoName(vPageSetting.getBoName()).setSortPlace(vPageSetting.getSortPlace()).setRemark(vPageSetting.getRemark()).setDisabledFlag(vPageSetting.getDisabledFlag()).setSetting(JSON.parse((String)vPageSetting.getSetting()))).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getPublishedVersionPages(Long appId, List<AppVersionChange> pageChanges) {
        List finalPageChanges = pageChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalPageChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalPageChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPage::getPublishRefPageId, (Object)pageChange.getResourceId())).eq(UltPage::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        List pUltPages = this.ultPageMapper.selectList((Wrapper)wrapper);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> new VersionPageBo().setId(pageBoSetting.getUniqueId()).setPageId(pUltPage.getPublishRefPageId()).setBoCode(pageBoSetting.getBoCode()).setBoName(pageBoSetting.getBoName()).setSortPlace(pageBoSetting.getSortPlace()).setRemark(pageBoSetting.getRemark()).setDisabledFlag(pageBoSetting.getDisabledFlag()).setSetting(JSON.parse((String)pageBoSetting.getSetting()))).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public HashMap<String, VersionPage> getVersionPagesNoSetting(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionPagesNoSetting(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, ResourceType.PAGE);
        return (HashMap)this.getPublishedVersionPagesNoSetting(appId, versionChanges);
    }

    public Map<String, VersionPage> getPublishedVersionPages(Long appId, AppVersion appVersion) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getDeleteFlag, (Object)"1")).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).le(AppVersion::getPublishTime, (Object)appVersion.getPublishTime())).orderByDesc(AppVersion::getPublishTime));
        if (appVersions.isEmpty()) {
            return Maps.newHashMap();
        }
        AppVersion lastAppVersion = (AppVersion)appVersions.get(0);
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(lastAppVersion.getId(), ResourceType.PAGE);
        if (versionChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.getPublishedVersionPages(appId, versionChanges);
    }

    public Map<String, VersionPage> getLatestVersionPagesNoSetting(Long appId) {
        ArrayList pUltPages;
        List ultPages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
        if (ultPages.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper ultPageWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1")).and(w -> ultPages.forEach(page -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(UltPage::getPublishRefPageId, (Object)page.getId())).eq(UltPage::getVersion, (Object)page.getVersion());
        }));
        List list = pUltPages = ultPages.isEmpty() ? Lists.newArrayList() : this.ultPageMapper.selectList((Wrapper)ultPageWrapper);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(PageBoSetting.class, field -> !field.getColumn().equals("setting")).in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> VersionUltPageStructMapper.MAPPER.toVersionPageBo((PageBoSetting)pageBoSetting, (UltPage)pUltPage)).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getUnPublishedPagesNoSetting(Long appId) {
        List ultPages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
        if (ultPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = ultPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> versionPageSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(PageBoSetting.class, field -> !field.getColumn().equals("setting")).in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return ultPages.stream().map(ultPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)ultPage);
            Optional.ofNullable(versionPageSettingMap.get(versionPage.getId())).ifPresent(vPageSettings -> {
                Map<String, VersionPageBo> versionPageBos = vPageSettings.parallelStream().map(VersionUltPageStructMapper.MAPPER::toVersionPageBo).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getPublishedVersionPagesNoSetting(Long appId, List<AppVersionChange> pageChanges) {
        List finalPageChanges = pageChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalPageChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalPageChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPage::getPublishRefPageId, (Object)pageChange.getResourceId())).eq(UltPage::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        List pUltPages = this.ultPageMapper.selectList((Wrapper)wrapper);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(PageBoSetting.class, field -> !field.getColumn().equals("setting")).in(PageBoSetting::getPageId, pageIds)).eq(PageBoSetting::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> VersionUltPageStructMapper.MAPPER.toVersionPageBo((PageBoSetting)pageBoSetting, (UltPage)pUltPage)).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }
}

