/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSueRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRuleParam;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(RuleVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private ISueRuleService sueRuleService;
    @Autowired
    private ISueRuleParamService sueRuleParamService;

    public HashMap<String, VersionRule> getVersionRules(Long appId, Long appVersionId) {
        AppVersionChange sueRuleVersionChange;
        String version = null == appVersionId ? this.getLatestSueRuleVersion(appId) : ((sueRuleVersionChange = (AppVersionChange)this.appVersionQuery.getAppVersionChange(appVersionId, ResourceType.RULE).orElse(null)) == null ? null : sueRuleVersionChange.getResourceVersion());
        return null == version ? Maps.newHashMap() : (HashMap)this.getPublishedVersionRules(appId, version);
    }

    public String getLatestSueRuleVersion(Long appId) {
        List uSueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(SueRule::getPublishFlag)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(SueRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        })).orderByDesc(SueRule::getCreateTime));
        return this.getLatestSueRuleVersion(appId, uSueRules);
    }

    public String getLatestSueRuleVersion(Long appId, List<SueRule> uSueRules) {
        if (uSueRules.isEmpty()) {
            List pSueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(SueRule::getId));
            return pSueRules.isEmpty() ? null : ((SueRule)pSueRules.get(0)).getVersion();
        }
        return uSueRules.get(0).getVersion();
    }

    public Map<String, VersionRule> getUnPublishedSueRules(Long appId) {
        List sueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (sueRules.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<SueRuleParam>> sueRuleParamsMap = this.sueRuleParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SueRuleParam::getRuleId, (Collection)sueRules.stream().map(SueRule::getId).collect(Collectors.toList()))).eq(SueRuleParam::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId));
        return sueRules.stream().map(sueRule -> {
            VersionRule versionSueRule = VersionSueRuleStructMapper.MAPPER.toVersionRule((SueRule)sueRule);
            Optional.ofNullable(sueRuleParamsMap.get(sueRule.getId())).ifPresent(sueRuleParams -> versionSueRule.setParams(sueRuleParams.stream().map(VersionSueRuleStructMapper.MAPPER::toVersionRuleParam).collect(Collectors.toMap(p -> p.getId().toString(), Functions.identity()))));
            return versionSueRule;
        }).collect(Collectors.toMap(sueRule -> String.valueOf(sueRule.getId()), Functions.identity()));
    }

    public Map<String, VersionRule> getPublishedVersionRules(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List sueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getVersion, (Object)version));
        if (sueRules.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<SueRuleParam>> sueRuleParamsMap = this.sueRuleParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SueRuleParam::getRuleId, (Collection)sueRules.stream().map(SueRule::getId).collect(Collectors.toList()))).eq(SueRuleParam::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId));
        return sueRules.stream().map(sueRule -> {
            VersionRule versionSueRule = VersionSueRuleStructMapper.MAPPER.toVersionRule((SueRule)sueRule);
            Optional.ofNullable(sueRuleParamsMap.get(sueRule.getId())).ifPresent(sueRuleParams -> versionSueRule.setParams(sueRuleParams.stream().map(VersionSueRuleStructMapper.MAPPER::toVersionRuleParam).collect(Collectors.toMap(p -> p.getId().toString(), Functions.identity()))));
            return versionSueRule;
        }).collect(Collectors.toMap(versionSueRule -> String.valueOf(versionSueRule.getId()), Functions.identity()));
    }
}

