/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.apis.enums.ApiType;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.ApisStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionApiStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionApiAuthTpl;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionApiAuthTplEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ApisAuthTemplate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ApisAuthTemplateEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ApisMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisAuthTplEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisAuthTplRepository;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(ApiVersionPublishExecutor.class);
    private List<ApiType> SOURCE_ID_TYPES = Arrays.asList(ApiType.METADATA, ApiType.AUTOFLOW);
    @Autowired
    private IApisService apisService;
    @Autowired
    private ApisMapper apisMapper;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApisAuthTplRepository apisAuthTplRepository;
    @Autowired
    private ApisAuthTplEnvRepository apisAuthTplEnvRepository;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnApiChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getApiChanges(), publishContent.getAddApiChanges());
        } else {
            this.publishVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List rApiss;
        List apiss = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (apiss.isEmpty()) {
            return;
        }
        ArrayList copyApiss = Lists.newArrayList();
        apiss.forEach(authTpl -> {
            Apis copyApis = ApisStructMapper.MAPPER.clone(authTpl);
            copyApis.setId(null);
            copyApis.setPublishFlag(PublishFlag.PUBLISHED.code());
            copyApis.setVersion(nVersion);
            copyApiss.add(copyApis);
        });
        this.apisService.saveBatch((Collection)copyApiss);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            apiss.forEach(authTpl -> {
                authTpl.setVersion(nVersion);
                this.apisMapper.alwaysUpdateSomeColumnById(authTpl);
            });
        }
        if (CollectionUtils.isNotEmpty(rApiss = copyApiss.stream().filter(a -> null != a.getSourceId() && VersionIdMapThreadLocal.getInstance().getIdMap().containsKey(a.getSourceId()) && StringUtils.isNotBlank((CharSequence)a.getApiType()) && this.SOURCE_ID_TYPES.contains(ApiType.fromValue((String)a.getApiType()))).map(a -> {
            a.setSourceId(VersionIdMapThreadLocal.getInstance().getIdMap().get(a.getSourceId()));
            return a;
        }).collect(Collectors.toList()))) {
            this.apisService.updateBatchById(rApiss);
        }
        this.fillTemplateContent(copyApiss);
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addApiChanges) {
        List uApiss = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List pApiss = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getVersion, (Object)originVersion)).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pApiss.stream().collect(Collectors.toMap(Apis::getUniqueId, Apis::getId));
        Tuple3<List<Apis>, List<Apis>, List<Apis>> apisChanges = this.publishCommonService.dealApisChanges(changedItems, addApiChanges, apiUniIdVTplOriginIdMap);
        ArrayList copyApiss = Lists.newArrayList();
        HashMap oriApisIdVCopyApisMap = Maps.newHashMap();
        List dApisIds = ((List)apisChanges._2).stream().map(Apis::getId).collect(Collectors.toList());
        pApiss.stream().filter(apis -> !dApisIds.contains(apis.getId())).forEach(apis -> {
            Apis copyApis = ApisStructMapper.MAPPER.clone(apis).setId(null).setVersion(newVersion);
            copyApiss.add(copyApis);
            oriApisIdVCopyApisMap.put(apis.getId(), copyApis);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)apisChanges._1))) {
            ((List)apisChanges._1).forEach(apis -> {
                Apis copyApis = ApisStructMapper.MAPPER.clone(apis).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copyApiss.add(copyApis);
                oriApisIdVCopyApisMap.put(apis.getId(), copyApis);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)apisChanges._3))) {
            ((List)apisChanges._3).forEach(apis -> {
                Optional<Apis> uOptl = copyApiss.stream().filter(cApis -> apis.getId().equals(cApis.getUniqueId())).findAny();
                if (uOptl.isPresent()) {
                    VersionApiStructMapper.MAPPER.updateApis((Apis)apis, uOptl.get());
                }
            });
        }
        this.apisService.saveBatch((Collection)copyApiss);
        List rApiss = copyApiss.stream().filter(a -> null != a.getSourceId() && VersionIdMapThreadLocal.getInstance().getIdMap().containsKey(a.getSourceId()) && StringUtils.isNotBlank((CharSequence)a.getApiType()) && this.SOURCE_ID_TYPES.contains(ApiType.fromValue((String)a.getApiType()))).map(a -> {
            a.setSourceId(VersionIdMapThreadLocal.getInstance().getIdMap().get(a.getSourceId()));
            return a;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rApiss)) {
            this.apisService.updateBatchById(rApiss);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uApiss.forEach(apis -> apis.setVersion(newVersion));
            if (!uApiss.isEmpty()) {
                this.apisService.updateBatchById((Collection)uApiss);
            }
        }
        this.fillTemplateContent(copyApiss);
    }

    private void fillTemplateContent(List<Apis> versionApis) {
        List templateCodes = versionApis.stream().map(Apis::getTemplateCode).collect(Collectors.toList());
        Map apisAuthTemplateMap = this.apisAuthTplRepository.getApisAuthTplsByCodes(templateCodes).stream().collect(Collectors.toMap(ApisAuthTemplate::getAuthTemplateCode, Function.identity()));
        versionApis.forEach(api -> Optional.ofNullable(apisAuthTemplateMap.get(api.getTemplateCode())).ifPresent(authTpl -> {
            VersionApiAuthTpl vAuthTpl = VersionApiStructMapper.MAPPER.toVersionApiAuthTpl((ApisAuthTemplate)authTpl);
            vAuthTpl.setAuthTemplateContent((VersionApiAuthTpl.AuthTemplateContent)JSON.parseObject((String)authTpl.getAuthTemplateContent(), VersionApiAuthTpl.AuthTemplateContent.class));
            List<VersionApiAuthTplEnv> vAuthTplEnvs = this.apisAuthTplEnvRepository.getApisAuthTplEnvs(authTpl.getId()).stream().map(authTplEnv -> {
                VersionApiAuthTplEnv vAuthTplEnv = VersionApiStructMapper.MAPPER.toVersionApiAuthTplEnv((ApisAuthTemplateEnv)authTplEnv);
                vAuthTplEnv.setEnvVariable(JSON.parseArray((String)authTplEnv.getEnvVariable(), VersionApiAuthTplEnv.EnvVariable.class));
                return vAuthTplEnv;
            }).collect(Collectors.toList());
            vAuthTpl.setEnvs(vAuthTplEnvs);
            api.setTemplateContent(JSON.toJSONString((Object)vAuthTpl));
        }));
        this.apisService.updateBatchById(versionApis);
    }
}

