/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionAppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppEventMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppEventVersionPublishExecutor {
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private AppEventMapper appEventMapper;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnAppEventChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getAppEventChanges(), publishContent.getAddAppEventChanges());
        } else {
            this.publishVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List appEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (appEvents.isEmpty()) {
            return;
        }
        ArrayList copyAppEvents = Lists.newArrayList();
        appEvents.forEach(e -> {
            AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(e);
            copyAppEvent.setId(null);
            copyAppEvent.setPublishEventId(e.getId());
            copyAppEvent.setPublishFlag(PublishFlag.PUBLISHED.code());
            copyAppEvent.setVersion(nVersion);
            copyAppEvents.add(copyAppEvent);
        });
        this.appEventService.saveBatch((Collection)copyAppEvents);
        Map<Long, Long> uniIdVsIdMap = copyAppEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
        List rpAppEvents = copyAppEvents.stream().filter(e -> null != e.getRefEventId()).map(e -> {
            Optional.ofNullable(uniIdVsIdMap.get(e.getRefEventId())).ifPresent(arg_0 -> ((AppEvent)e).setRefEventId(arg_0));
            return e;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpAppEvents)) {
            this.appEventService.updateBatchById(rpAppEvents);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            appEvents.forEach(e -> {
                e.setVersion(nVersion);
                this.appEventMapper.alwaysUpdateSomeColumnById(e);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addAppEventChanges) {
        List uAppEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List pAppEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getVersion, (Object)originVersion)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pAppEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
        Tuple3<List<AppEvent>, List<AppEvent>, List<AppEvent>> appEventChanges = this.publishCommonService.dealAppEventChanges(changedItems, addAppEventChanges, apiUniIdVTplOriginIdMap);
        ArrayList copyAppEvents = Lists.newArrayList();
        List dAppEventIds = ((List)appEventChanges._2).stream().map(AppEvent::getId).collect(Collectors.toList());
        pAppEvents.stream().filter(appEvent -> !dAppEventIds.contains(appEvent.getId())).forEach(appEvent -> {
            AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(appEvent).setId(null).setVersion(newVersion);
            copyAppEvents.add(copyAppEvent);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)appEventChanges._1))) {
            ((List)appEventChanges._1).forEach(appEvent -> {
                AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(appEvent).setId(null).setPublishEventId(appEvent.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copyAppEvents.add(copyAppEvent);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)appEventChanges._3))) {
            ((List)appEventChanges._3).forEach(appEvent -> {
                Optional<AppEvent> uOptl = copyAppEvents.stream().filter(cAppEvent -> appEvent.getId().equals(cAppEvent.getUniqueId())).findAny();
                uOptl.ifPresent(event -> VersionAppEventStructMapper.MAPPER.updateAppEvent((AppEvent)appEvent, (AppEvent)event));
            });
        }
        this.appEventService.saveBatch((Collection)copyAppEvents);
        Map<Long, Long> publishIdVsIdMap = copyAppEvents.stream().collect(Collectors.toMap(AppEvent::getPublishEventId, AppEvent::getId));
        List rpAppEvents = copyAppEvents.stream().filter(e -> null != e.getRefEventId()).map(e -> {
            Optional.ofNullable(publishIdVsIdMap.get(e.getRefEventId())).ifPresent(arg_0 -> ((AppEvent)e).setRefEventId(arg_0));
            return e;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpAppEvents)) {
            this.appEventService.updateBatchById(rpAppEvents);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uAppEvents.forEach(appEvent -> appEvent.setVersion(newVersion));
            if (!uAppEvents.isEmpty()) {
                this.appEventService.updateBatchById((Collection)uAppEvents);
            }
        }
    }
}

