/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionDictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DictMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(DictVersionPublishExecutor.class);
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnDictChanges())) {
            this.publishDictVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getDictChanges(), publishContent.getAddDictChanges());
        } else {
            this.publishDictVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishDictVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List dicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(Dict::getPublishFlag)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        }));
        if (dicts.isEmpty()) {
            return;
        }
        ArrayList copyDicts = Lists.newArrayList();
        dicts.forEach(dict -> {
            Dict copyDict = DictStructMapper.MAPPER.clone(dict);
            copyDict.setId(null);
            copyDict.setPublishDictId(dict.getId());
            copyDict.setPublishFlag(PublishFlag.PUBLISHED.code());
            copyDict.setVersion(nVersion);
            copyDicts.add(copyDict);
        });
        this.dictService.saveBatch((Collection)copyDicts);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            dicts.forEach(dict -> {
                dict.setVersion(nVersion);
                this.dictMapper.alwaysUpdateSomeColumnById(dict);
            });
        }
        List dictIds = dicts.stream().map(Dict::getId).collect(Collectors.toList());
        Map<Long, List<DictDetail>> dictDetailMap = this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictDetail::getDeleteFlag, (Object)"1")).in(DictDetail::getDictId, dictIds)).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        ArrayList copyDictDetails = Lists.newArrayList();
        copyDicts.forEach(copyDict -> Optional.ofNullable(dictDetailMap.get(copyDict.getPublishDictId())).ifPresent(dictDetails -> dictDetails.forEach(dictDetail -> {
            DictDetail copyDictDetail = DictDetailStructMapper.MAPPER.clone(dictDetail);
            copyDictDetail.setId(null);
            copyDictDetail.setDictId(copyDict.getId());
            copyDictDetail.setVersion(nVersion);
            copyDictDetails.add(copyDictDetail);
            if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
                dictDetail.setVersion(VersionUtils.nextVersion((String)dictDetail.getVersion(), (AppVersionType)appVersionType));
            }
        })));
        this.dictDetailService.saveBatch((Collection)copyDictDetails);
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && !dictDetailMap.isEmpty()) {
            List updateDictDetails = dictDetailMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.dictDetailService.updateBatchById(updateDictDetails);
        }
    }

    private void publishDictVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addDictChanges) {
        List uDicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List uDictIds = uDicts.stream().map(Dict::getId).collect(Collectors.toList());
        HashMap uDictDetailsMap = uDictIds.isEmpty() ? Maps.newHashMap() : this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(DictDetail::getDictId, uDictIds)).eq(DictDetail::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(DictDetail::getDictId, Collectors.toList()));
        List pDicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getVersion, (Object)originVersion)).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        List pDictIds = pDicts.stream().map(Dict::getId).collect(Collectors.toList());
        HashMap pDictDetailsMap = pDictIds.isEmpty() ? Maps.newHashMap() : this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(DictDetail::getDictId, pDictIds)).eq(DictDetail::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(DictDetail::getDictId, Collectors.toList()));
        Map<Long, Long> pPDictIdVOriDictId = pDicts.stream().collect(Collectors.toMap(Dict::getPublishDictId, Dict::getId));
        Tuple6<List<Dict>, List<Dict>, List<Dict>, List<DictDetail>, List<DictDetail>, List<DictDetail>> dictChanges = this.publishCommonService.dealDictChanges(changedItems, addDictChanges, pPDictIdVOriDictId);
        ArrayList copyDicts = Lists.newArrayList();
        HashMap oriDictIdVCopyDictMap = Maps.newHashMap();
        List dDictIds = ((List)dictChanges._2).stream().map(Dict::getId).collect(Collectors.toList());
        pDicts.stream().filter(dict -> !dDictIds.contains(dict.getId())).forEach(dict -> {
            Dict copyDict = DictStructMapper.MAPPER.clone(dict).setId(null).setVersion(newVersion);
            copyDicts.add(copyDict);
            oriDictIdVCopyDictMap.put(dict.getId(), copyDict);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._1))) {
            ((List)dictChanges._1).forEach(dict -> {
                Dict copyDict = DictStructMapper.MAPPER.clone(dict).setId(null).setPublishDictId(dict.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copyDicts.add(copyDict);
                oriDictIdVCopyDictMap.put(dict.getId(), copyDict);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._3))) {
            ((List)dictChanges._3).forEach(dict -> {
                Optional<Dict> uOptl = copyDicts.stream().filter(cDict -> dict.getId().equals(cDict.getPublishDictId())).findAny();
                if (uOptl.isPresent()) {
                    VersionDictStructMapper.MAPPER.updateDict((Dict)dict, uOptl.get());
                }
            });
        }
        this.dictService.saveBatch((Collection)copyDicts);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uDicts.forEach(dict -> dict.setVersion(newVersion));
            if (!uDicts.isEmpty()) {
                this.dictService.updateBatchById((Collection)uDicts);
            }
        }
        List aDictIds = ((List)dictChanges._1).stream().map(Dict::getId).collect(Collectors.toList());
        ArrayList copyDictDetails = Lists.newArrayList();
        List dDictDlIds = ((List)dictChanges._5).stream().map(DictDetail::getId).collect(Collectors.toList());
        Map<Long, List<DictDetail>> rDictDlsMap = ((List)dictChanges._6).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        copyDicts.forEach(copyDict -> {
            if (CollectionUtils.isNotEmpty((Collection)aDictIds) && aDictIds.contains(copyDict.getPublishDictId())) {
                Optional.ofNullable(uDictDetailsMap.get(copyDict.getPublishDictId())).ifPresent(dictDetails -> dictDetails.stream().filter(dictDl -> !dDictDlIds.contains(dictDl.getId())).forEach(dictDetail -> copyDictDetails.add(DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId(copyDict.getId()).setVersion(newVersion))));
            } else {
                Long pOriDictId = (Long)pPDictIdVOriDictId.get(copyDict.getPublishDictId());
                Optional.ofNullable(pDictDetailsMap.get(pOriDictId)).ifPresent(dictDetails -> {
                    Optional.ofNullable(rDictDlsMap.get(copyDict.getPublishDictId())).ifPresent(rDictDls -> rDictDls.forEach(rDictDl -> dictDetails.stream().filter(dictDl -> rDictDl.getCode().equals(dictDl.getCode())).findAny().ifPresent(dictDl -> VersionDictStructMapper.MAPPER.updateDictDetail((DictDetail)rDictDl, (DictDetail)dictDl))));
                    dictDetails.stream().filter(dictDl -> !dDictDlIds.contains(dictDl.getId())).forEach(dictDetail -> copyDictDetails.add(DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId(copyDict.getId()).setVersion(newVersion)));
                });
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._4))) {
            Map<Long, Long> nPDictIdsVDictIds = copyDicts.stream().collect(Collectors.toMap(Dict::getPublishDictId, Dict::getId));
            ((List)dictChanges._4).forEach(dictDetail -> {
                DictDetail copyDictDetail = DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId((Long)nPDictIdsVDictIds.get(dictDetail.getDictId()));
                copyDictDetails.add(copyDictDetail);
            });
        }
        this.dictDetailService.saveBatch((Collection)copyDictDetails);
    }
}

