/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.FlowActionParamStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.FlowActionStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionFlowStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.FlowActionMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowActionVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(FlowActionVersionPublishExecutor.class);
    @Autowired
    private FlowActionMapper flowActionMapper;
    @Autowired
    private IFlowActionParamService flowActionParamService;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnFlowActionChanges())) {
            this.publishFlowActionVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getFlowActionChanges(), publishContent.getAddFlowActionChanges());
        } else {
            this.publishFlowActionVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishFlowActionVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List flowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId));
        if (flowActions.isEmpty()) {
            return;
        }
        ArrayList copyFlowActions = Lists.newArrayList();
        flowActions.forEach(flowAction -> {
            FlowAction copyFlowAction = FlowActionStructMapper.MAPPER.clone(flowAction);
            copyFlowAction.setId(null);
            copyFlowAction.setPublishActionId(flowAction.getId());
            copyFlowAction.setVersion(nVersion);
            copyFlowActions.add(copyFlowAction);
        });
        this.flowActionService.saveBatch((Collection)copyFlowActions);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            flowActions.forEach(flowAction -> {
                flowAction.setVersion(nVersion);
                this.flowActionMapper.alwaysUpdateSomeColumnById(flowAction);
            });
        }
        List flowActionIds = flowActions.stream().map(FlowAction::getId).collect(Collectors.toList());
        Map<Long, List<FlowActionParam>> flowActionParamMap = this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, flowActionIds)).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId));
        ArrayList copyFlowActionParams = Lists.newArrayList();
        copyFlowActions.forEach(copyFlowAction -> Optional.ofNullable(flowActionParamMap.get(copyFlowAction.getPublishActionId())).ifPresent(flowActionParams -> flowActionParams.forEach(flowActionParam -> {
            FlowActionParam copyFlowActionParam = FlowActionParamStructMapper.MAPPER.clone(flowActionParam);
            copyFlowActionParam.setId(null);
            copyFlowActionParam.setActionId(copyFlowAction.getId());
            copyFlowActionParams.add(copyFlowActionParam);
        })));
        this.flowActionParamService.saveBatch((Collection)copyFlowActionParams);
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && !flowActionParamMap.isEmpty()) {
            List updateFlowActionParams = flowActionParamMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.flowActionParamService.updateBatchById(updateFlowActionParams);
        }
    }

    private void publishFlowActionVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addFlowActionChanges) {
        List uFlowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId));
        List uFlowActionIds = uFlowActions.stream().map(FlowAction::getId).collect(Collectors.toList());
        HashMap uFlowActionParamsMap = uFlowActionIds.isEmpty() ? Maps.newHashMap() : this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, uFlowActionIds)).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId, Collectors.toList()));
        List pFlowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getVersion, (Object)originVersion)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNotNull(FlowAction::getPublishActionId));
        List pFlowActionIds = pFlowActions.stream().map(FlowAction::getId).collect(Collectors.toList());
        HashMap pFlowActionParamsMap = pFlowActionIds.isEmpty() ? Maps.newHashMap() : this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, pFlowActionIds)).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId, Collectors.toList()));
        Map<Long, Long> pPFlowActionIdVOriFlowActionId = pFlowActions.stream().collect(Collectors.toMap(FlowAction::getPublishActionId, FlowAction::getId));
        Tuple6<List<FlowAction>, List<FlowAction>, List<FlowAction>, List<FlowActionParam>, List<FlowActionParam>, List<FlowActionParam>> flowActionChanges = this.publishCommonService.dealFlowActionChanges(changedItems, addFlowActionChanges, pPFlowActionIdVOriFlowActionId);
        ArrayList copyFlowActions = Lists.newArrayList();
        HashMap oriFlowActionIdVCopyFlowActionMap = Maps.newHashMap();
        List dFlowActionIds = ((List)flowActionChanges._2).stream().map(FlowAction::getId).collect(Collectors.toList());
        pFlowActions.stream().filter(flowAction -> !dFlowActionIds.contains(flowAction.getId())).forEach(flowAction -> {
            FlowAction copyFlowAction = FlowActionStructMapper.MAPPER.clone(flowAction).setId(null).setVersion(newVersion);
            copyFlowActions.add(copyFlowAction);
            oriFlowActionIdVCopyFlowActionMap.put(flowAction.getId(), copyFlowAction);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowActionChanges._1))) {
            ((List)flowActionChanges._1).forEach(flowAction -> {
                FlowAction copyFlowAction = FlowActionStructMapper.MAPPER.clone(flowAction).setId(null).setPublishActionId(flowAction.getId()).setVersion(newVersion);
                copyFlowActions.add(copyFlowAction);
                oriFlowActionIdVCopyFlowActionMap.put(flowAction.getId(), copyFlowAction);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowActionChanges._3))) {
            ((List)flowActionChanges._3).forEach(flowAction -> {
                Optional<FlowAction> uOptl = copyFlowActions.stream().filter(cFlowAction -> flowAction.getId().equals(cFlowAction.getPublishActionId())).findAny();
                if (uOptl.isPresent()) {
                    VersionFlowStructMapper.MAPPER.updateFlowAction((FlowAction)flowAction, uOptl.get());
                }
            });
        }
        this.flowActionService.saveBatch((Collection)copyFlowActions);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uFlowActions.forEach(flowAction -> flowAction.setVersion(newVersion));
            if (!uFlowActions.isEmpty()) {
                this.flowActionService.updateBatchById((Collection)uFlowActions);
            }
        }
        List aFlowActionIds = ((List)flowActionChanges._1).stream().map(FlowAction::getId).collect(Collectors.toList());
        ArrayList copyFlowActionParams = Lists.newArrayList();
        List dFlowActionDlIds = ((List)flowActionChanges._5).stream().map(FlowActionParam::getId).collect(Collectors.toList());
        Map<Long, List<FlowActionParam>> rFlowActionDlsMap = ((List)flowActionChanges._6).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId));
        copyFlowActions.forEach(copyFlowAction -> {
            if (CollectionUtils.isNotEmpty((Collection)aFlowActionIds) && aFlowActionIds.contains(copyFlowAction.getPublishActionId())) {
                Optional.ofNullable(uFlowActionParamsMap.get(copyFlowAction.getPublishActionId())).ifPresent(flowActionParams -> flowActionParams.stream().filter(flowActionDl -> !dFlowActionDlIds.contains(flowActionDl.getId())).forEach(flowActionParam -> copyFlowActionParams.add(FlowActionParamStructMapper.MAPPER.clone(flowActionParam).setId(null).setActionId(copyFlowAction.getId()))));
            } else {
                Long pOriFlowActionId = (Long)pPFlowActionIdVOriFlowActionId.get(copyFlowAction.getPublishActionId());
                Optional.ofNullable(pFlowActionParamsMap.get(pOriFlowActionId)).ifPresent(flowActionParams -> {
                    Optional.ofNullable(rFlowActionDlsMap.get(copyFlowAction.getPublishActionId())).ifPresent(rFlowActionDls -> rFlowActionDls.forEach(rFlowActionDl -> flowActionParams.stream().filter(flowActionDl -> rFlowActionDl.getParamType().equals(flowActionDl.getParamType()) && rFlowActionDl.getParamIndex().equals(flowActionDl.getParamIndex())).findAny().ifPresent(flowActionDl -> VersionFlowStructMapper.MAPPER.updateFlowActionParam((FlowActionParam)rFlowActionDl, (FlowActionParam)flowActionDl))));
                    flowActionParams.stream().filter(flowActionDl -> !dFlowActionDlIds.contains(flowActionDl.getId())).forEach(flowActionParam -> copyFlowActionParams.add(FlowActionParamStructMapper.MAPPER.clone(flowActionParam).setId(null).setActionId(copyFlowAction.getId())));
                });
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowActionChanges._4))) {
            Map<Long, Long> nPFlowActionIdsVFlowActionIds = copyFlowActions.stream().collect(Collectors.toMap(FlowAction::getPublishActionId, FlowAction::getId));
            ((List)flowActionChanges._4).forEach(flowActionParam -> {
                FlowActionParam copyFlowActionParam = FlowActionParamStructMapper.MAPPER.clone(flowActionParam).setId(null).setActionId((Long)nPFlowActionIdsVFlowActionIds.get(flowActionParam.getActionId()));
                copyFlowActionParams.add(copyFlowActionParam);
            });
        }
        this.flowActionParamService.saveBatch((Collection)copyFlowActionParams);
    }
}

