/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.FlowSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(FlowSettingVersionPublishExecutor.class);
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private FlowSettingVersionQuery flowSettingVersionQuery;

    @SkipAutoAudit
    public ServiceResponse publish(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark, String nVersion, String originVersion) {
        if (AppVersionType.PATCH.equals((Object)appVersionType) && (StringUtils.isEmpty((CharSequence)nVersion) || StringUtils.isEmpty((CharSequence)originVersion))) {
            throw new RuntimeException("\u5f53\u53d1\u5e03\u8865\u4e01\u7248\u672c\u65f6\uff0c\u65b0\u7248\u672c\u548c\u539f\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u5b58\u5728");
        }
        List<FlowSetting> pFlowSettings = AppVersionType.PATCH.equals((Object)appVersionType) ? this.flowSettingVersionQuery.getFlowSettings(appId, originVersion) : this.flowSettingVersionQuery.getLatestVersionFlowSettings(appId);
        Map<Long, Long> pPFlowSettingIdVOriFlowSettingId = pFlowSettings.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, FlowSetting::getId));
        Tuple3<List<FlowSetting>, List<FlowSetting>, List<FlowSetting>> flowSettingChanges = this.publishCommonService.dealFlowSettingChanges(changedItems, pPFlowSettingIdVOriFlowSettingId);
        ArrayList copyFlowSettings = Lists.newArrayList();
        HashMap oriFlowSettingIdVCopyFlowSettingMap = Maps.newHashMap();
        Set dStandardIds = ((List)flowSettingChanges._2).stream().filter(e -> e.getRefFlowId() == null).map(FlowSetting::getId).collect(Collectors.toSet());
        Set dCustomIds = ((List)flowSettingChanges._2).stream().filter(e -> e.getRefFlowId() != null).map(FlowSetting::getId).collect(Collectors.toSet());
        pFlowSettings.stream().filter(flow -> !dStandardIds.contains(flow.getId()) && !dStandardIds.contains(flow.getRefFlowId()) && !dCustomIds.contains(flow.getId())).forEach(flowSetting -> {
            FlowSetting copyFlowSetting = FlowSettingStructMapper.MAPPER.clone(flowSetting);
            copyFlowSettings.add(copyFlowSetting);
            oriFlowSettingIdVCopyFlowSettingMap.put(flowSetting.getId(), copyFlowSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowSettingChanges._1))) {
            ((List)flowSettingChanges._1).forEach(flowSetting -> {
                FlowSetting copyFlowSetting = FlowSettingStructMapper.MAPPER.clone(flowSetting).setId(null).setPublishFlowId(flowSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code());
                copyFlowSettings.add(copyFlowSetting);
                oriFlowSettingIdVCopyFlowSettingMap.put(flowSetting.getId(), copyFlowSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowSettingChanges._3))) {
            ((List)flowSettingChanges._3).forEach(uFlowSetting -> {
                Optional<FlowSetting> pFlowSettingOptl = copyFlowSettings.stream().filter(cFlowSetting -> uFlowSetting.getId().equals(cFlowSetting.getPublishFlowId())).findAny();
                if (pFlowSettingOptl.isPresent()) {
                    FlowSettingStructMapper.MAPPER.update(uFlowSetting, pFlowSettingOptl.get());
                    pFlowSettingOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, FlowSetting> pBasicFlowSettingMap = pFlowSettings.stream().filter(flow -> flow.getRefFlowId() == null).collect(Collectors.toMap(FlowSetting::getId, Function.identity()));
        List<Long> needChangedFlowSettingIds = this.getNeedChangedFlowSettingIds(flowSettingChanges, pBasicFlowSettingMap);
        HashMap flowSettingNewVersionMap = Maps.newHashMap();
        copyFlowSettings.stream().filter(flow -> flow.getRefFlowId() == null).forEach(flowSetting -> {
            String nFlowSettingVersion = flowSetting.getVersion();
            if (needChangedFlowSettingIds.contains(flowSetting.getPublishFlowId())) {
                nFlowSettingVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? nVersion : VersionUtils.nextVersion((String)flowSetting.getVersion(), (AppVersionType)appVersionType);
            }
            flowSettingNewVersionMap.put(flowSetting.getPublishFlowId(), nFlowSettingVersion);
            versionInfos.put(flowSetting.getPublishFlowId(), new VersionInfo().setPublishId(flowSetting.getPublishFlowId()).setOriginVersion(flowSetting.getVersion()).setNewVersion(nFlowSettingVersion));
            flowSetting.setVersion(nFlowSettingVersion);
        });
        copyFlowSettings.stream().filter(flow -> flow.getRefFlowId() != null).forEach(flow -> {
            Optional.ofNullable(pBasicFlowSettingMap.get(flow.getRefFlowId())).ifPresent(pFlow -> flow.setRefFlowId(pFlow.getPublishFlowId()));
            if (flowSettingNewVersionMap.containsKey(flow.getRefFlowId())) {
                String nFlowVersion = (String)flowSettingNewVersionMap.get(flow.getRefFlowId());
                versionInfos.put(flow.getPublishFlowId(), new VersionInfo().setPublishId(flow.getPublishFlowId()).setOriginVersion(flow.getVersion()).setNewVersion(nFlowVersion));
                flow.setVersion(nFlowVersion);
            } else {
                log.error(String.format("\u6d41-%d\u627e\u4e0d\u5230\u6d41\u4e3b\u6570\u636e-{%s}\uff0c\u5bfc\u81f4\u7248\u672c\u65e0\u6cd5\u66f4\u65b0\u548c\u6ca1\u6709\u5173\u8054\u5e94\u7528\u7248\u672c", flow.getId(), flow.getRefFlowId()));
            }
        });
        List copyFlowSettingsNeedSave = copyFlowSettings.stream().filter(f -> needChangedFlowSettingIds.contains(f.getPublishFlowId()) || needChangedFlowSettingIds.contains(f.getRefFlowId())).map(flowSetting -> flowSetting.setId(null)).collect(Collectors.toList());
        this.flowSettingService.saveBatch(copyFlowSettingsNeedSave);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            List uFlowSettings = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(appId);
            List uFlowSettingsNeedUpdateVersion = uFlowSettings.stream().filter(f -> needChangedFlowSettingIds.contains(f.getId()) || needChangedFlowSettingIds.contains(f.getRefFlowId())).map(uFlowSetting -> {
                String version = (String)flowSettingNewVersionMap.get(uFlowSetting.getId());
                return uFlowSetting.setVersion(version);
            }).collect(Collectors.toList());
            this.flowSettingService.updateBatchById(uFlowSettingsNeedUpdateVersion);
        }
        Map pFlowIdVCopyFlowMap = copyFlowSettings.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, Function.identity()));
        List rFlowSettings = copyFlowSettings.stream().filter(f -> f.getRefFlowId() != null && needChangedFlowSettingIds.contains(f.getRefFlowId())).map(flow -> {
            Long refFlowId;
            Long l = refFlowId = pFlowIdVCopyFlowMap.containsKey(flow.getRefFlowId()) ? ((FlowSetting)pFlowIdVCopyFlowMap.get(flow.getRefFlowId())).getId() : null;
            if (refFlowId == null) {
                throw new RuntimeException(String.format("\u6839\u636eFlowSetting RefFlowId\u627e\u4e0d\u5230\u5bf9\u5e94\u5feb\u7167\u6d41ID %d ", flow.getRefFlowId()));
            }
            return flow.setRefFlowId(refFlowId);
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rFlowSettings)) {
            this.flowSettingService.updateBatchById(rFlowSettings);
        }
        Optional.ofNullable(VersionIdMapThreadLocal.getInstance().getIdMap()).ifPresent(idMap -> {
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(oriFlowSettingIdVCopyFlowSettingMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FlowSetting)e.getValue()).getId())));
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(pPFlowSettingIdVOriFlowSettingId);
        });
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedFlowSettingIds(Tuple3<List<FlowSetting>, List<FlowSetting>, List<FlowSetting>> flowSettingChanges, Map<Long, FlowSetting> pBasicFlowSettingMap) {
        HashSet flowSettingIds = Sets.newHashSet();
        ((List)flowSettingChanges._1).forEach(item -> {
            if (item.getRefFlowId() == null) {
                flowSettingIds.add(item.getId());
            } else {
                flowSettingIds.add(item.getRefFlowId());
            }
        });
        ((List)flowSettingChanges._2).forEach(item -> {
            if (item.getRefFlowId() == null) {
                flowSettingIds.add(item.getPublishFlowId());
            } else {
                Long flowSettingId;
                Long l = flowSettingId = pBasicFlowSettingMap.containsKey(item.getRefFlowId()) ? ((FlowSetting)pBasicFlowSettingMap.get(item.getRefFlowId())).getRefFlowId() : null;
                if (flowSettingId != null) {
                    flowSettingIds.add(flowSettingId);
                }
            }
        });
        ((List)flowSettingChanges._3).forEach(item -> {
            if (item.getRefFlowId() == null) {
                flowSettingIds.add(item.getId());
            } else {
                flowSettingIds.add(item.getRefFlowId());
            }
        });
        return new ArrayList<Long>(flowSettingIds);
    }
}

