/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.UltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltFormMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(FormVersionPublishExecutor.class);
    @Autowired
    private UltFormMapper ultFormMapper;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FormVersionQuery formVersionQuery;

    @SkipAutoAudit
    public ServiceResponse publish(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark, String nVersion, String originVersion) {
        if (AppVersionType.PATCH.equals((Object)appVersionType) && (StringUtils.isEmpty((CharSequence)nVersion) || StringUtils.isEmpty((CharSequence)originVersion))) {
            throw new RuntimeException("\u5f53\u53d1\u5e03\u8865\u4e01\u7248\u672c\u65f6\uff0c\u65b0\u7248\u672c\u548c\u539f\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u5b58\u5728");
        }
        List<UltForm> pForms = AppVersionType.PATCH.equals((Object)appVersionType) ? this.formVersionQuery.getForms(appId, originVersion) : this.formVersionQuery.getLatestVersionForms(appId);
        Map<Long, Long> pPFormIdVOriFormId = pForms.stream().collect(Collectors.toMap(UltForm::getPublishRefFormId, UltForm::getId));
        Tuple3<List<UltForm>, List<UltForm>, List<UltForm>> formChanges = this.publishCommonService.dealFormChanges(changedItems, pPFormIdVOriFormId);
        ArrayList copyForms = Lists.newArrayList();
        HashMap oriFormIdVCopyFormMap = Maps.newHashMap();
        Set dBasicFormIds = ((List)formChanges._2).stream().filter(form -> form.getRefFormId() == 0L).map(UltForm::getId).collect(Collectors.toSet());
        Set dTenantFormIds = ((List)formChanges._2).stream().filter(form -> form.getRefFormId() != 0L).map(UltForm::getId).collect(Collectors.toSet());
        pForms.stream().filter(form -> !dBasicFormIds.contains(form.getId()) && !dBasicFormIds.contains(form.getRefFormId()) && !dTenantFormIds.contains(form.getId())).forEach(form -> {
            UltForm copyForm = UltFormStructMapper.MAPPER.clone(form);
            copyForms.add(copyForm);
            oriFormIdVCopyFormMap.put(form.getId(), copyForm);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formChanges._1))) {
            ((List)formChanges._1).forEach(form -> {
                UltForm copyForm = UltFormStructMapper.MAPPER.clone(form).setId(null).setPublishRefFormId(form.getId()).setPublishFlag(PfcpPublishFlag.PUBLISHED.code());
                copyForms.add(copyForm);
                oriFormIdVCopyFormMap.put(form.getId(), copyForm);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formChanges._3))) {
            ((List)formChanges._3).forEach(uForm -> {
                Optional<UltForm> pFormOptl = copyForms.stream().filter(cForm -> uForm.getId().equals(cForm.getPublishRefFormId())).findAny();
                if (pFormOptl.isPresent()) {
                    UltFormStructMapper.MAPPER.updateForm(uForm, pFormOptl.get());
                    pFormOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, UltForm> pBasicFormMap = pForms.stream().filter(form -> form.getRefFormId() == 0L).collect(Collectors.toMap(UltForm::getId, Function.identity()));
        List<Long> needChangedBasicFormIds = this.getNeedChangedBasicFormIds(formChanges, pBasicFormMap);
        HashMap basicFormNewVersionMap = Maps.newHashMap();
        copyForms.stream().filter(form -> form.getRefFormId() == 0L).forEach(form -> {
            String nFormVersion = form.getVersion();
            if (needChangedBasicFormIds.contains(form.getPublishRefFormId())) {
                nFormVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? nVersion : VersionUtils.nextVersion((String)form.getVersion(), (AppVersionType)appVersionType);
            }
            basicFormNewVersionMap.put(form.getPublishRefFormId(), nFormVersion);
            versionInfos.put(form.getPublishRefFormId(), new VersionInfo().setPublishId(form.getPublishRefFormId()).setOriginVersion(form.getVersion()).setNewVersion(nFormVersion));
            form.setVersion(nFormVersion);
        });
        copyForms.stream().filter(form -> form.getRefFormId() != 0L).forEach(form -> {
            Optional.ofNullable(pBasicFormMap.get(form.getRefFormId())).ifPresent(pForm -> form.setRefFormId(pForm.getPublishRefFormId()));
            if (basicFormNewVersionMap.containsKey(form.getRefFormId())) {
                String nFormVersion = (String)basicFormNewVersionMap.get(form.getRefFormId());
                versionInfos.put(form.getPublishRefFormId(), new VersionInfo().setPublishId(form.getPublishRefFormId()).setOriginVersion(form.getVersion()).setNewVersion(nFormVersion));
                form.setVersion(nFormVersion);
            } else {
                log.error(String.format("\u8868\u5355-%d\u627e\u4e0d\u5230\u8868\u5355\u4e3b\u6570\u636e-{%s}\uff0c\u5bfc\u81f4\u7248\u672c\u65e0\u6cd5\u66f4\u65b0\u548c\u6ca1\u6709\u5173\u8054\u5e94\u7528\u7248\u672c", form.getId(), form.getRefFormId()));
            }
        });
        copyForms.stream().filter(f -> needChangedBasicFormIds.contains(f.getPublishRefFormId()) || needChangedBasicFormIds.contains(f.getRefFormId())).forEach(form -> this.ultFormMapper.insert((Object)form.setId(null)));
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            List<UltForm> uForms = this.formVersionQuery.getUnPublishedForms(appId);
            uForms.stream().filter(f -> needChangedBasicFormIds.contains(f.getId()) || needChangedBasicFormIds.contains(f.getRefFormId())).forEach(uForm -> {
                String version = uForm.getRefFormId() == 0L ? (String)basicFormNewVersionMap.get(uForm.getId()) : (String)basicFormNewVersionMap.get(uForm.getRefFormId());
                uForm.setVersion(version);
                this.ultFormMapper.updateById(uForm);
            });
        }
        Map pFormIdVCopyFormMap = copyForms.stream().collect(Collectors.toMap(UltForm::getPublishRefFormId, Function.identity()));
        copyForms.stream().filter(f -> f.getRefFormId() != 0L && needChangedBasicFormIds.contains(f.getRefFormId())).forEach(form -> {
            Long refFormId;
            Long l = refFormId = pFormIdVCopyFormMap.containsKey(form.getRefFormId()) ? ((UltForm)pFormIdVCopyFormMap.get(form.getRefFormId())).getId() : null;
            if (refFormId != null) {
                form.setRefFormId(refFormId);
                this.ultFormMapper.updateById(form);
            }
        });
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedBasicFormIds(Tuple3<List<UltForm>, List<UltForm>, List<UltForm>> formChanges, Map<Long, UltForm> pBasicFormMap) {
        HashSet formIds = Sets.newHashSet();
        ((List)formChanges._1).forEach(item -> {
            if (item.getRefFormId() == 0L) {
                formIds.add(item.getId());
            } else {
                formIds.add(item.getRefFormId());
            }
        });
        ((List)formChanges._2).forEach(item -> {
            if (item.getRefFormId() == 0L) {
                formIds.add(item.getPublishRefFormId());
            } else {
                Long formId;
                Long l = formId = pBasicFormMap.containsKey(item.getRefFormId()) ? ((UltForm)pBasicFormMap.get(item.getRefFormId())).getPublishRefFormId() : null;
                if (formId != null) {
                    formIds.add(formId);
                }
            }
        });
        ((List)formChanges._3).forEach(item -> {
            if (item.getRefFormId() == 0L) {
                formIds.add(item.getId());
            } else {
                formIds.add(item.getRefFormId());
            }
        });
        return new ArrayList<Long>(formIds);
    }
}

