/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueRuleParamStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSueRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRuleParam;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.SueRuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleVersionPublishExecutor {
    @Autowired
    private SueRuleMapper sueRuleMapper;
    @Autowired
    private ISueRuleParamService sueRuleParamService;
    @Autowired
    private ISueRuleService sueRuleService;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnRuleChanges())) {
            this.publishSueRuleVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getRuleChanges(), publishContent.getAddRuleChanges());
        } else {
            this.publishSueRuleVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishSueRuleVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List sueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(SueRule::getPublishFlag)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(SueRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        }));
        if (sueRules.isEmpty()) {
            return;
        }
        ArrayList copySueRules = Lists.newArrayList();
        sueRules.forEach(sueRule -> {
            SueRule copySueRule = SueRuleStructMapper.MAPPER.clone(sueRule);
            copySueRule.setId(null);
            copySueRule.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySueRule.setVersion(nVersion);
            copySueRules.add(copySueRule);
        });
        this.sueRuleService.saveBatch((Collection)copySueRules);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            sueRules.forEach(sueRule -> {
                sueRule.setVersion(nVersion);
                this.sueRuleMapper.alwaysUpdateSomeColumnById(sueRule);
            });
        }
        List sueRuleIds = sueRules.stream().map(SueRule::getId).collect(Collectors.toList());
        Map<Long, List<SueRuleParam>> sueRuleParamMap = this.sueRuleParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRuleParam::getDeleteFlag, (Object)"1")).in(SueRuleParam::getRuleId, sueRuleIds)).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId));
        ArrayList copySueRuleParams = Lists.newArrayList();
        copySueRules.forEach(copySueRule -> Optional.ofNullable(sueRuleParamMap.get(copySueRule.getUniqueId())).ifPresent(sueRuleParams -> sueRuleParams.forEach(sueRuleParam -> {
            SueRuleParam copySueRuleParam = SueRuleParamStructMapper.MAPPER.clone(sueRuleParam);
            copySueRuleParam.setId(null);
            copySueRuleParam.setRuleId(copySueRule.getId());
            copySueRuleParams.add(copySueRuleParam);
        })));
        this.sueRuleParamService.saveBatch((Collection)copySueRuleParams);
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && !sueRuleParamMap.isEmpty()) {
            List updateSueRuleParams = sueRuleParamMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.sueRuleParamService.updateBatchById(updateSueRuleParams);
        }
    }

    private void publishSueRuleVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addRuleChanges) {
        List uSueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List uRuleIds = uSueRules.stream().map(SueRule::getId).collect(Collectors.toList());
        HashMap uSueRuleParamsMap = uRuleIds.isEmpty() ? Maps.newHashMap() : this.sueRuleParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SueRuleParam::getRuleId, uRuleIds)).eq(SueRuleParam::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId, Collectors.toList()));
        List pSueRules = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getVersion, (Object)originVersion)).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        List pRuleIds = pSueRules.stream().map(SueRule::getId).collect(Collectors.toList());
        HashMap pSueRuleParamsMap = pRuleIds.isEmpty() ? Maps.newHashMap() : this.sueRuleParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SueRuleParam::getRuleId, pRuleIds)).eq(SueRuleParam::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId, Collectors.toList()));
        Map<Long, Long> pPRuleIdVOriRuleId = pSueRules.stream().collect(Collectors.toMap(SueRule::getUniqueId, SueRule::getId));
        Tuple6<List<SueRule>, List<SueRule>, List<SueRule>, List<SueRuleParam>, List<SueRuleParam>, List<SueRuleParam>> sueRuleChanges = this.publishCommonService.dealRuleChanges(changedItems, addRuleChanges, pPRuleIdVOriRuleId);
        ArrayList copySueRules = Lists.newArrayList();
        HashMap oriRuleIdVCopySueRuleMap = Maps.newHashMap();
        List dRuleIds = ((List)sueRuleChanges._2).stream().map(SueRule::getId).collect(Collectors.toList());
        pSueRules.stream().filter(sueRule -> !dRuleIds.contains(sueRule.getId())).forEach(sueRule -> {
            SueRule copySueRule = SueRuleStructMapper.MAPPER.clone(sueRule).setId(null).setVersion(newVersion);
            copySueRules.add(copySueRule);
            oriRuleIdVCopySueRuleMap.put(sueRule.getId(), copySueRule);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sueRuleChanges._1))) {
            ((List)sueRuleChanges._1).forEach(sueRule -> {
                SueRule copySueRule = SueRuleStructMapper.MAPPER.clone(sueRule).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copySueRules.add(copySueRule);
                oriRuleIdVCopySueRuleMap.put(sueRule.getId(), copySueRule);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sueRuleChanges._3))) {
            ((List)sueRuleChanges._3).forEach(sueRule -> {
                Optional<SueRule> uOptl = copySueRules.stream().filter(cSueRule -> sueRule.getId().equals(cSueRule.getUniqueId())).findAny();
                if (uOptl.isPresent()) {
                    VersionSueRuleStructMapper.MAPPER.updateRule((SueRule)sueRule, uOptl.get());
                }
            });
        }
        this.sueRuleService.saveBatch((Collection)copySueRules);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSueRules.forEach(sueRule -> sueRule.setVersion(newVersion));
            if (!uSueRules.isEmpty()) {
                this.sueRuleService.updateBatchById((Collection)uSueRules);
            }
        }
        List aRuleIds = ((List)sueRuleChanges._1).stream().map(SueRule::getId).collect(Collectors.toList());
        ArrayList copySueRuleParams = Lists.newArrayList();
        List dSueRuleDlIds = ((List)sueRuleChanges._5).stream().map(SueRuleParam::getId).collect(Collectors.toList());
        Map<Long, List<SueRuleParam>> rSueRuleDlsMap = ((List)sueRuleChanges._6).stream().collect(Collectors.groupingBy(SueRuleParam::getRuleId));
        copySueRules.forEach(copySueRule -> {
            if (CollectionUtils.isNotEmpty((Collection)aRuleIds) && aRuleIds.contains(copySueRule.getUniqueId())) {
                Optional.ofNullable(uSueRuleParamsMap.get(copySueRule.getUniqueId())).ifPresent(sueRuleParams -> sueRuleParams.stream().filter(sueRuleDl -> !dSueRuleDlIds.contains(sueRuleDl.getId())).forEach(sueRuleParam -> copySueRuleParams.add(SueRuleParamStructMapper.MAPPER.clone(sueRuleParam).setId(null).setRuleId(copySueRule.getId()))));
            } else {
                Long pOriRuleId = (Long)pPRuleIdVOriRuleId.get(copySueRule.getUniqueId());
                Optional.ofNullable(pSueRuleParamsMap.get(pOriRuleId)).ifPresent(sueRuleParams -> {
                    Optional.ofNullable(rSueRuleDlsMap.get(copySueRule.getUniqueId())).ifPresent(rSueRuleDls -> rSueRuleDls.forEach(rSueRuleDl -> sueRuleParams.stream().filter(sueRuleDl -> rSueRuleDl.getUniqueId().equals(sueRuleDl.getUniqueId())).findAny().ifPresent(sueRuleDl -> VersionSueRuleStructMapper.MAPPER.updateRuleParam((SueRuleParam)rSueRuleDl, (SueRuleParam)sueRuleDl))));
                    sueRuleParams.stream().filter(sueRuleDl -> !dSueRuleDlIds.contains(sueRuleDl.getId())).forEach(sueRuleParam -> copySueRuleParams.add(SueRuleParamStructMapper.MAPPER.clone(sueRuleParam).setId(null).setRuleId(copySueRule.getId())));
                });
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sueRuleChanges._4))) {
            Map<Long, Long> nPRuleIdsVRuleIds = copySueRules.stream().collect(Collectors.toMap(SueRule::getUniqueId, SueRule::getId));
            ((List)sueRuleChanges._4).forEach(sueRuleParam -> {
                SueRuleParam copySueRuleParam = SueRuleParamStructMapper.MAPPER.clone(sueRuleParam).setId(null).setRuleId((Long)nPRuleIdsVRuleIds.get(sueRuleParam.getRuleId()));
                copySueRuleParams.add(copySueRuleParam);
            });
        }
        this.sueRuleParamService.saveBatch((Collection)copySueRuleParams);
    }
}

