/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.sdkSetting.mapstruct.SdkSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSdkSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.SdkSettingMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdkSettingVersionPublishExecutor {
    @Autowired
    private ISdkSettingService sdkSettingService;
    @Autowired
    private SdkSettingMapper sdkSettingMapper;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnSdkSettingChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getSdkSettingChanges(), publishContent.getAddSdkSettingChanges());
        } else {
            this.publishVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List sdkSettings = this.sdkSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (sdkSettings.isEmpty()) {
            return;
        }
        ArrayList copySdkSettings = Lists.newArrayList();
        sdkSettings.forEach(e -> {
            SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(e);
            copySdkSetting.setId(null);
            copySdkSetting.setPublishSettingId(e.getId());
            copySdkSetting.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySdkSetting.setVersion(nVersion);
            copySdkSettings.add(copySdkSetting);
        });
        this.sdkSettingService.saveBatch((Collection)copySdkSettings);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            sdkSettings.forEach(e -> {
                e.setVersion(nVersion);
                this.sdkSettingMapper.alwaysUpdateSomeColumnById(e);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addSdkSettingChanges) {
        List uSdkSettings = this.sdkSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List pSdkSettings = this.sdkSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getVersion, (Object)originVersion)).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pSdkSettings.stream().collect(Collectors.toMap(SdkSetting::getUniqueId, SdkSetting::getId));
        Tuple3<List<SdkSetting>, List<SdkSetting>, List<SdkSetting>> sdkSettingChanges = this.publishCommonService.dealSdkSettingChanges(changedItems, addSdkSettingChanges, apiUniIdVTplOriginIdMap);
        ArrayList copySdkSettings = Lists.newArrayList();
        List dSdkSettingIds = ((List)sdkSettingChanges._2).stream().map(SdkSetting::getId).collect(Collectors.toList());
        pSdkSettings.stream().filter(sdkSetting -> !dSdkSettingIds.contains(sdkSetting.getId())).forEach(sdkSetting -> {
            SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(sdkSetting).setId(null).setVersion(newVersion);
            copySdkSettings.add(copySdkSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sdkSettingChanges._1))) {
            ((List)sdkSettingChanges._1).forEach(sdkSetting -> {
                SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(sdkSetting).setId(null).setPublishSettingId(sdkSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copySdkSettings.add(copySdkSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sdkSettingChanges._3))) {
            ((List)sdkSettingChanges._3).forEach(sdkSetting -> {
                Optional<SdkSetting> uOptl = copySdkSettings.stream().filter(cSdkSetting -> sdkSetting.getId().equals(cSdkSetting.getUniqueId())).findAny();
                uOptl.ifPresent(event -> VersionSdkSettingStructMapper.MAPPER.updateSdkSetting((SdkSetting)sdkSetting, (SdkSetting)event));
            });
        }
        this.sdkSettingService.saveBatch((Collection)copySdkSettings);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSdkSettings.forEach(sdkSetting -> sdkSetting.setVersion(newVersion));
            if (!uSdkSettings.isEmpty()) {
                this.sdkSettingService.updateBatchById((Collection)uSdkSettings);
            }
        }
    }
}

