/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.SueTagMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagVersionPublishExecutor {
    @Autowired
    private ISueTagService sueTagService;
    @Autowired
    private SueTagMapper sueTagMapper;
    @Autowired
    private PublishCommonService publishCommonService;

    @SkipAutoAudit
    public ServiceResponse publish(String nVersion, String originVersion, PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        if (CollectionUtils.isNotEmpty(publishContent.getUnTagChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), nVersion, originVersion, appVersionType, publishContent.getTagChanges(), publishContent.getAddTagChanges());
        } else {
            this.publishVersion(publishContent.getAppId(), nVersion, appVersionType);
        }
        return ServiceResponse.success();
    }

    private void publishVersion(Long appId, String nVersion, AppVersionType appVersionType) {
        List tags = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (tags.isEmpty()) {
            return;
        }
        ArrayList copySueTags = Lists.newArrayList();
        tags.forEach(authTpl -> {
            SueTag copySueTag = SueTagStructMapper.MAPPER.clone(authTpl);
            copySueTag.setId(null);
            copySueTag.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySueTag.setVersion(nVersion);
            copySueTags.add(copySueTag);
        });
        this.sueTagService.saveBatch((Collection)copySueTags);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            tags.forEach(authTpl -> {
                authTpl.setVersion(nVersion);
                this.sueTagMapper.alwaysUpdateSomeColumnById(authTpl);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addTagChanges) {
        List uSueTags = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        List pSueTags = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getVersion, (Object)originVersion)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pSueTags.stream().collect(Collectors.toMap(SueTag::getUniqueId, SueTag::getId));
        Tuple3<List<SueTag>, List<SueTag>, List<SueTag>> tagChanges = this.publishCommonService.dealTagChanges(changedItems, addTagChanges, apiUniIdVTplOriginIdMap);
        ArrayList copySueTags = Lists.newArrayList();
        HashMap oriSueTagIdVCopySueTagMap = Maps.newHashMap();
        List dSueTagIds = ((List)tagChanges._2).stream().map(SueTag::getId).collect(Collectors.toList());
        pSueTags.stream().filter(tag -> !dSueTagIds.contains(tag.getId())).forEach(tag -> {
            SueTag copySueTag = SueTagStructMapper.MAPPER.clone(tag).setId(null).setVersion(newVersion);
            copySueTags.add(copySueTag);
            oriSueTagIdVCopySueTagMap.put(tag.getId(), copySueTag);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tagChanges._1))) {
            ((List)tagChanges._1).forEach(tag -> {
                SueTag copySueTag = SueTagStructMapper.MAPPER.clone(tag).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copySueTags.add(copySueTag);
                oriSueTagIdVCopySueTagMap.put(tag.getId(), copySueTag);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tagChanges._3))) {
            ((List)tagChanges._3).forEach(tag -> {
                Optional<SueTag> uOptl = copySueTags.stream().filter(cSueTag -> tag.getId().equals(cSueTag.getUniqueId())).findAny();
                uOptl.ifPresent(sueTag -> VersionSueTagStructMapper.MAPPER.updateTag((SueTag)tag, (SueTag)sueTag));
            });
        }
        this.sueTagService.saveBatch((Collection)copySueTags);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSueTags.forEach(tag -> tag.setVersion(newVersion));
            if (!uSueTags.isEmpty()) {
                this.sueTagService.updateBatchById((Collection)uSueTags);
            }
        }
    }
}

