/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppVersionQuery {
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;

    public Optional<AppVersion> getLatestMainVersion(Long appId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).orderByDesc(AppVersion::getPublishTime)).last("limit 10"));
        return appVersions.stream().sorted((o1, o2) -> {
            int intV1 = VersionUtils.computeVersionInt((String)o1.getVersion());
            int intV2 = VersionUtils.computeVersionInt((String)o2.getVersion());
            return intV2 - intV1;
        }).findFirst();
    }

    public String getLatestMainVersionIncludeDelete(Long appId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{AppVersion::getVersion}).eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).orderByDesc(AppVersion::getPublishTime)).last("limit 10"));
        return appVersions.stream().sorted((o1, o2) -> {
            int intV1 = VersionUtils.computeVersionInt((String)o1.getVersion());
            int intV2 = VersionUtils.computeVersionInt((String)o2.getVersion());
            return intV2 - intV1;
        }).findFirst().orElse(new AppVersion()).getVersion();
    }

    public List<AppVersion> getAppVersions(Long appId) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getDeleteFlag, (Object)"1"));
    }

    public Optional<AppVersion> getAppVersion(Long appId, String appVersion) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersion, (Object)appVersion)).eq(AppVersion::getDeleteFlag, (Object)"1")).stream().findAny();
    }

    public Optional<AppVersion> getAppVersion(Long appVersionId) {
        return Optional.ofNullable(this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getId, (Object)appVersionId)).eq(AppVersion::getDeleteFlag, (Object)"1"), false));
    }

    public Optional<AppVersion> getAppVersion(Long appId, Long appVersionId) {
        return Optional.ofNullable(this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)appVersionId), false));
    }

    public Optional<AppVersionChange> getLatestAppVersionChange(Long appId, ResourceType resourceType) {
        Optional<AppVersion> appVersionOptl = this.getLatestMainVersion(appId);
        if (!appVersionOptl.isPresent()) {
            return Optional.empty();
        }
        return this.getAppVersionChange(appVersionOptl.get().getId(), resourceType);
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appId, String appVersion, ResourceType resourceType) {
        Optional<AppVersion> appVersionOptl = this.getAppVersion(appId, appVersion);
        if (!appVersionOptl.isPresent()) {
            return Optional.empty();
        }
        return this.getAppVersionChange(appVersionOptl.get().getId(), resourceType);
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appVersionId, ResourceType resourceType) {
        if (!Arrays.asList(ResourceType.BO, ResourceType.DICT, ResourceType.FLOW_ACTION, ResourceType.API, ResourceType.RULE, ResourceType.TAG, ResourceType.APP_EVENT, ResourceType.SDK_SETTING).contains((Object)resourceType)) {
            throw new RuntimeException("\u9519\u8bef\u7684\u8d44\u6e90\u7c7b\u578b");
        }
        AppVersionChange appVersionChange = (AppVersionChange)this.appVersionChangeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getResourceType, (Object)resourceType.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"), false);
        return Optional.ofNullable(appVersionChange);
    }

    public List<AppVersionChange> getAppVersionChanges(Long appId, String appVersion, ResourceType resourceType) {
        Optional<AppVersion> appVersionOptl = this.getAppVersion(appId, appVersion);
        if (!appVersionOptl.isPresent()) {
            return Lists.newArrayList();
        }
        return this.getAppVersionChanges(appVersionOptl.get().getId(), resourceType);
    }

    public List<AppVersionChange> getAppVersionChanges(Long appVersionId, ResourceType resourceType) {
        if (!Arrays.asList(ResourceType.PAGE, ResourceType.FORM, ResourceType.FLOW_SETTING).contains((Object)resourceType)) {
            throw new RuntimeException("\u9519\u8bef\u7684\u8d44\u6e90\u7c7b\u578b");
        }
        return this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getResourceType, (Object)resourceType.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1")).isNotNull(AppVersionChange::getResourceId));
    }

    public List<AppVersionChange> getAppVersionChanges(Long appVersionId) {
        return this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appId, Long envId, ResourceType resourceType) {
        AppEnv appEnv = (AppEnv)this.appEnvService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEnv::getAppId, (Object)appId)).eq(AppEnv::getEnvId, (Object)envId)).eq(AppEnv::getDeleteFlag, (Object)"1"));
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Optional.empty();
        }
        return this.getAppVersionChange(appEnv.getAppVersionId(), resourceType);
    }
}

