/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoVersionQuery {
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private DefaultModuleService defaultModuleService;

    public List<Bo> getBos(Long appId, String version) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, version, ResourceType.BO).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), versionChange.getResourceVersion());
        if (!moduleOptl.isPresent()) {
            return Lists.newArrayList();
        }
        return this.defaultModuleService.getBos(((Module)moduleOptl.get()).getId());
    }

    public List<Bo> getBos(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (appVersion == null) {
            return Lists.newArrayList();
        }
        return this.getBos(appVersion.getAppId(), appVersion.getVersion());
    }

    public List<Bo> getBos(Long appId, Long envId) {
        AppEnv appEnv = (AppEnv)this.appEnvService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEnv::getAppId, (Object)appId)).eq(AppEnv::getEnvId, (Object)envId));
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        return this.getBos(appEnv.getAppVersionId());
    }

    public List<Bo> getLatestBos(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        return appVersionOptl.isPresent() ? this.getBos(appVersionOptl.get().getId()) : Lists.newArrayList();
    }
}

