/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private FlowSettingRepository flowSettingRepository;

    public List<FlowSetting> getLatestVersionFlowSettings(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), ResourceType.FLOW_SETTING);
            return this.getFlowSettings(appId, versionChanges);
        }
        return this.getLatestVersionFlowSettingsByUnPublishFlowSettings(appId);
    }

    public List<FlowSetting> getLatestVersionFlowSettingsByUnPublishFlowSettings(Long appId) {
        List flowSettings = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(appId);
        if (flowSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList pFlowSettingss = Lists.newArrayList();
        flowSettings.forEach(flowSetting -> {
            FlowSetting pFlowSetting = (FlowSetting)this.flowSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(FlowSetting::getPublishFlowId, (Object)flowSetting.getId())).eq(FlowSetting::getVersion, (Object)flowSetting.getVersion())).eq(FlowSetting::getDeleteFlag, (Object)"1"), false);
            if (pFlowSetting != null) {
                pFlowSettingss.add(pFlowSetting);
            }
        });
        return pFlowSettingss;
    }

    public List<FlowSetting> getFlowSettings(Long appId, String version) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, version, ResourceType.FLOW_SETTING);
        return this.getFlowSettings(appId, versionChanges);
    }

    private List<FlowSetting> getFlowSettings(Long appId, List<AppVersionChange> versionChanges) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        wrapper.and(w -> versionChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlowId, (Object)pageChange.getResourceId())).eq(FlowSetting::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        return versionChanges.isEmpty() ? Lists.newArrayList() : this.flowSettingService.list((Wrapper)wrapper);
    }
}

