/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltFormMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private UltFormMapper ultFormMapper;

    public List<UltForm> getUnPublishedForms(Long appId) {
        return this.ultFormMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1"));
    }

    public List<UltForm> getLatestVersionFormsWhenNoAppVersion(Long appId) {
        List ultForms = this.ultFormMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1"));
        if (ultForms.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList pUltForms = Lists.newArrayList();
        ultForms.forEach(ultForm -> {
            UltForm pUltForm = (UltForm)this.ultFormMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltForm::getPublishRefFormId, (Object)ultForm.getId())).eq(UltForm::getVersion, (Object)ultForm.getVersion())).eq(UltForm::getDeleteFlag, (Object)"1"));
            if (pUltForm != null) {
                pUltForms.add(pUltForm);
            }
        });
        return pUltForms;
    }

    public List<UltForm> getLatestVersionForms(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), ResourceType.FORM);
            return this.getForms(appId, versionChanges);
        }
        return this.getLatestVersionFormsWhenNoAppVersion(appId);
    }

    public List<UltForm> getForms(Long appId, String version) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, version, ResourceType.FORM);
        return this.getForms(appId, versionChanges);
    }

    private List<UltForm> getForms(Long appId, List<AppVersionChange> versionChanges) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> versionChanges.forEach(formChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)formChange.getResourceId())).eq(UltForm::getVersion, (Object)formChange.getResourceVersion());
            });
        }));
        return versionChanges.isEmpty() ? Lists.newArrayList() : this.ultFormMapper.selectList((Wrapper)wrapper);
    }
}

