/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltPageMapper;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private UltPageMapper ultPageMapper;

    public List<UltPage> getUnPublishedPages(Long appId) {
        return this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
    }

    public List<UltPage> getLatestVersionPages(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), ResourceType.PAGE);
            return this.getPages(appId, versionChanges);
        }
        return this.getLatestVersionPagesWhenNoAppVersion(appId);
    }

    public List<UltPage> getPages(Long appId, String version) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, version, ResourceType.PAGE);
        return this.getPages(appId, versionChanges);
    }

    private List<UltPage> getPages(Long appId, List<AppVersionChange> versionChanges) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> versionChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPage::getPublishRefPageId, (Object)pageChange.getResourceId())).eq(UltPage::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        return versionChanges.isEmpty() ? Lists.newArrayList() : this.ultPageMapper.selectList((Wrapper)wrapper);
    }

    public List<UltPage> getLatestVersionPagesWhenNoAppVersion(Long appId) {
        List ultPages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1"));
        if (ultPages.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList pUltPages = Lists.newArrayList();
        ultPages.forEach(ultPage -> {
            UltPage pUltPage = (UltPage)this.ultPageMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltPage::getPublishRefPageId, (Object)ultPage.getId())).eq(UltPage::getVersion, (Object)ultPage.getVersion())).eq(UltPage::getDeleteFlag, (Object)"1"));
            if (pUltPage != null) {
                pUltPages.add(pUltPage);
            }
        });
        return pUltPages;
    }
}

