/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagVersionQuery {
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private ISueTagService sueTagService;

    public List<SueTag> getTags(Long appId, String version) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, version, ResourceType.TAG).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getVersion, (Object)versionChange.getResourceVersion())).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        return this.sueTagService.list((Wrapper)wrapper);
    }

    public List<SueTag> getTags(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (null == appVersion) {
            return Lists.newArrayList();
        }
        return this.getTags(appVersion.getAppId(), appVersion.getVersion());
    }
}

