/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.common.CommonBusiness;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IBoExService;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowActionVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionChangeExService;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import com.xforceplus.ultraman.bocp.metadata.vo.FlowActionVo;
import com.xforceplus.ultraman.bocp.metadata.vo.PageVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionRepository;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppVersionChangeExServiceImpl
implements IAppVersionChangeExService {
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private IBoExService boExService;
    @Autowired
    private FlowActionRepository flowActionRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private FlowActionVersionQuery flowActionVersionQuery;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;

    @Override
    public List<PageVersion> getPagePublishVersions(Long appId, Long pageId) {
        ArrayList pageVersions = Lists.newArrayList();
        List appVersionIds = this.appVersionQuery.getAppVersions(appId).stream().map(AppVersion::getId).collect(Collectors.toList());
        if (appVersionIds.isEmpty()) {
            return pageVersions;
        }
        this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(AppVersionChange::getAppVersionId, appVersionIds)).eq(AppVersionChange::getResourceId, (Object)pageId)).eq(AppVersionChange::getResourceType, (Object)ResourceType.PAGE.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1")).stream().map(AppVersionChange::getResourceVersion).distinct().forEach(version -> pageVersions.add(new PageVersion().setId(pageId).setVersion(version)));
        return pageVersions;
    }

    @Override
    public List<BoInfoVo> getBoInfos(Long appVersionId, String dataType) {
        List boIds = this.metadataVersionQuery.getBos(appVersionId).stream().map(Bo::getId).collect(Collectors.toList());
        if (boIds.isEmpty()) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((CharSequence)dataType)) {
            return this.boExService.getBoInfos((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).eq(Bo::getBoType, (Object)BoType.ENTITY.code())).in(Bo::getId, boIds));
        }
        if ("simple".equals(dataType)) {
            return this.boRepository.getBosByIds(boIds, Arrays.asList(BoType.ENTITY.code())).stream().map(bo -> new BoInfoVo().setId(bo.getId()).setCode(bo.getCode()).setName(bo.getName()).setBoType(bo.getBoType()).setLevel(bo.getLevel()).setSysType(bo.getSysType()).setVersion(bo.getVersion()).setPublishBoId(bo.getPublishBoId()).setPublishFlag(bo.getPublishFlag()).setCreateType(bo.getCreateType()).setParentBoId(bo.getParentBoId()).setRefBoId(bo.getRefBoId()).setTenantId(bo.getTenantId()).setTenantCode(bo.getTenantCode()).setTenantName(bo.getTenantName())).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public BoInfoVo getBoInfo(Long appVersionId, Long boId) {
        List<Bo> bos = this.metadataVersionQuery.getBos(appVersionId);
        if (CollectionUtils.isEmpty(bos)) {
            return null;
        }
        if (bos.stream().noneMatch(bo -> bo.getId().equals(boId))) {
            return null;
        }
        return this.boExService.getBoInfoById(boId);
    }

    @Override
    public List<BoInfoVo> getVersionBoInfos(Long appId, String version) {
        Optional<AppVersion> appVersionOptional = this.appVersionQuery.getAppVersion(appId, version);
        if (!appVersionOptional.isPresent()) {
            return Lists.newArrayList();
        }
        return this.getBoInfos(appVersionOptional.get().getId(), "simple");
    }

    @Override
    public List<FlowSetting> getVersionFlows(Long appId, String version) {
        return this.metadataVersionQuery.getFlowSettings(appId, version);
    }

    @Override
    public List<FlowActionVo> getVersionActions(Long appId, String version) {
        List<FlowAction> flowActions = this.flowActionVersionQuery.getFlowActions(appId, version);
        return this.flowActionRepository.getFlowActionVos(flowActions);
    }

    @Override
    public List<Dict> getVersionDicts(Long appId, String version) {
        return this.metadataVersionQuery.getDicts(appId, version);
    }

    @Override
    public List<UltPage> getVersionUltPages(Long appId, String version) {
        return this.metadataVersionQuery.getPages(appId, version);
    }

    @Override
    public List<UltForm> getVersionUltForms(Long appId, String version) {
        return this.metadataVersionQuery.getForms(appId, version);
    }

    @Override
    public List<DictVo> getVersionDicts(Long appVersionId) {
        return this.metadataVersionQuery.getDicts(appVersionId).stream().map(dt -> {
            DictVo dictVo = DictStructMapper.MAPPER.toVo(dt);
            List dictDetailVos = this.dictDetailRepository.getDictDetails(dt.getId()).stream().map(CommonBusiness::convertDictDetailToVo).collect(Collectors.toList());
            dictVo.setOptions(dictDetailVos);
            return dictVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<Apis> getVersionApis(Long appId, String version) {
        return this.metadataVersionQuery.getApis(appId, version);
    }

    @Override
    public List<SdkSetting> getVersionSdkSettings(Long appId, String version) {
        return this.metadataVersionQuery.getSdkSettings(appId, version);
    }
}

