/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.alibaba.ttl.TtlRunnable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.common.CommonBusiness;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.VersionStatus;
import com.xforceplus.ultraman.bocp.metadata.exception.ServiceException;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleInfoExService;
import com.xforceplus.ultraman.bocp.metadata.util.FormatUtil;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.DictVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionExService;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryAppVersionVo;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryBoVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppEnvMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IModuleService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.PageBoSettingMapper;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltFormMapper;
import com.xforceplus.ultraman.metadata.repository.pfcp.mapper.UltPageMapper;
import com.xforceplus.ultraman.mybatisplus.core.api.XfPage;
import com.xforceplus.ultraman.pfcp.setting.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppVersionExServiceImpl
implements IAppVersionExService {
    private static final Logger log = LoggerFactory.getLogger(AppVersionExServiceImpl.class);
    @Autowired
    private AppEnvMapper appEnvMapper;
    @Autowired
    private UltPageMapper ultPageMapper;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    @Autowired
    private UltFormMapper ultFormMapper;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private IFlowActionParamService flowActionParamService;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private IApisService apisService;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private IModuleInfoExService moduleInfoExService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private DictVersionQuery dictVersionQuery;

    @Override
    public IPage<AppVersion> queryAppVersions(XfPage page, QueryAppVersionVo appVersion) {
        Optional appVersionOptl;
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"delete_flag", (Object)"1")).eq((Object)"app_id", (Object)appVersion.getAppId());
        if (!StringUtils.isEmpty((CharSequence)appVersion.getSort())) {
            String[] sort = appVersion.getSort().split(" ");
            if (sort.length == 2) {
                if ("asc".equals(sort[1])) {
                    wrapper.orderByAsc((Object)FormatUtil.lowerCamelToLowerUnderscore((String)sort[0]));
                } else if ("desc".equals(sort[1])) {
                    wrapper.orderByDesc((Object)FormatUtil.lowerCamelToLowerUnderscore((String)sort[0]));
                }
            }
        } else {
            wrapper.orderByDesc((Object)"create_time");
        }
        if (appVersion.getCreateTime() != null) {
            wrapper.ge((Object)"create_time", (Object)appVersion.getCreateTime());
        }
        if (appVersion.getUpdateTime() != null) {
            wrapper.le((Object)"update_time", (Object)appVersion.getUpdateTime());
        }
        if (!StringUtils.isEmpty((CharSequence)appVersion.getVersion())) {
            wrapper.eq((Object)"version", (Object)appVersion.getVersion());
        }
        if (!StringUtils.isEmpty((CharSequence)appVersion.getVersionStatus())) {
            wrapper.eq((Object)"version_status", (Object)appVersion.getVersionStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)appVersion.getVersionTypes())) {
            wrapper.in((Object)"version_type", (Collection)appVersion.getVersionTypes());
        }
        if (null != appVersion.getMainVersionId()) {
            wrapper.eq((Object)"main_version_id", (Object)appVersion.getMainVersionId());
        }
        Long appVersionId = (appVersionOptl = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appVersion.getAppId())).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).orderByDesc(AppVersion::getPublishTime)).stream().findFirst()).isPresent() && VersionStatus.TEST.code().equals(((AppVersion)appVersionOptl.get()).getVersionStatus()) ? ((AppVersion)appVersionOptl.get()).getId() : null;
        IPage pageResult = this.appVersionService.page((IPage)page, (Wrapper)wrapper);
        if (appVersionId != null) {
            pageResult.getRecords().forEach(appV -> {
                if (appV.getId().equals(appVersionId)) {
                    appV.setDeleteFlag("0");
                }
            });
        }
        return pageResult;
    }

    @Override
    public ServiceResponse clearAppVersion(Long appId) {
        List<AppVersion> appVersions = this.appVersionQuery.getAppVersions(appId);
        if (!appVersions.isEmpty()) {
            appVersions.forEach(av -> av.setDeleteFlag("0"));
            this.appVersionService.updateBatchById(appVersions);
            AppVersionChange appVersionChange = new AppVersionChange().setDeleteFlag("0");
            this.appVersionChangeService.update((Object)appVersionChange, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().in(AppVersionChange::getAppVersionId, (Collection)appVersions.stream().map(AppVersion::getId).collect(Collectors.toList()))).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
        }
        List appEnvs = this.appEnvService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEnv::getAppId, (Object)appId)).isNotNull(AppEnv::getAppVersionId)).eq(AppEnv::getDeleteFlag, (Object)"1"));
        appEnvs.forEach(ae -> this.appEnvMapper.alwaysUpdateSomeColumnById((Object)ae.setAppVersionId(null).setDeployVersion(null).setDeployerName(null).setDeployerId(null)));
        return ServiceResponse.success((String)"");
    }

    @Override
    public ServiceResponse updateVersionStatus(Long appId, Long id, String versionStatus) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getDeleteFlag, (Object)"1")).eq(AppVersion::getId, (Object)id)).eq(AppVersion::getAppId, (Object)appId), false);
        if (appVersion == null) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u8be5\u5e94\u7528\u7248\u672c");
        }
        if (VersionStatus.fromCode((String)versionStatus) == null) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u8981\u66f4\u65b0\u7684\u7248\u672c\u72b6\u6001");
        }
        appVersion.setVersionStatus(versionStatus);
        this.appVersionService.updateById((Object)appVersion);
        return ServiceResponse.success((String)"");
    }

    @Override
    public AppVersion getLatestVersion(Long appId) {
        return this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
    }

    @Override
    public String getNewAppVersion(long appId, String versionType) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)versionType);
        if (appVersionType == null) {
            throw ServiceException.businessFail((String)"\u7248\u672c\u7c7b\u578b\u4e3a\u7a7a");
        }
        String appVersion = this.appVersionQuery.getLatestMainVersionIncludeDelete(appId);
        if (StringUtils.isEmpty((CharSequence)appVersion)) {
            Optional moduleOptl = this.defaultModuleService.getModule(appId);
            appVersion = moduleOptl.isPresent() ? ((Module)moduleOptl.get()).getVersion() : "0.0.0";
        }
        return VersionUtils.nextVersion((String)appVersion, (AppVersionType)appVersionType);
    }

    @Override
    public String getNewAppPatchVersion(long appId, long appVersionId) {
        AppVersion fromAppVersion = this.appVersionQuery.getAppVersion((Long)appId, appVersionId).orElse(null);
        if (null == fromAppVersion) {
            return null;
        }
        Long mainVersionId = AppVersionType.PATCH.code().equals(fromAppVersion.getVersionType()) ? fromAppVersion.getMainVersionId() : appVersionId;
        List appPatchVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getMainVersionId, (Object)mainVersionId)).eq(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).orderByDesc(AppVersion::getPublishTime));
        if (appPatchVersions.isEmpty()) {
            return fromAppVersion.getVersion() + ".1";
        }
        String[] versionParts = ((AppVersion)appPatchVersions.get(0)).getVersion().split("\\.");
        if (versionParts.length != 4) {
            throw new RuntimeException(String.format("\u9519\u8bef\u7684\u7248\u672c\u53f7\uff1a%s", ((AppVersion)appPatchVersions.get(0)).getVersion()));
        }
        return String.format("%s.%s.%s.%s", versionParts[0], versionParts[1], versionParts[2], Integer.parseInt(versionParts[3]) + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse removeAppVersion(Long appId, Long appVersionId) throws InterruptedException {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersionStatus, (Object)VersionStatus.TEST.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).orderByDesc(AppVersion::getPublishTime));
        if (appVersions.isEmpty()) {
            return ServiceResponse.fail((String)"\u67e5\u4e0d\u5230\u5e94\u7528\u6d4b\u8bd5\u7248\u672c");
        }
        AppVersion appVersion = (AppVersion)appVersions.get(0);
        if (!appVersion.getId().equals(appVersionId)) {
            return ServiceResponse.fail((String)"\u5e94\u7528\u7248\u672c\u5fc5\u987b\u662f\u6700\u65b0\u53d1\u5e03\u7684\u6d4b\u8bd5\u7248\u672c");
        }
        List appPatchVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getMainVersionId, (Object)appVersionId)).eq(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1"));
        if (!appPatchVersions.isEmpty()) {
            for (AppVersion patchVersion : appPatchVersions) {
                this.doRemoveAppVersion(patchVersion);
            }
        }
        this.doRemoveAppVersion(appVersion);
        log.debug("\u5220\u9664\u5e94\u7528\u7248\u672c\u6210\u529f");
        return ServiceResponse.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse removeAppPatchVersion(Long appId, Long appVersionId) throws InterruptedException {
        AppVersion appVersion = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)appVersionId)).eq(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1"), false);
        if (null == appVersion) {
            return ServiceResponse.fail((String)"\u67e5\u4e0d\u5230\u5e94\u7528\u8865\u4e01\u7248\u672c");
        }
        List childPatchVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getParentVersionId, (Object)appVersionId)).eq(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1"));
        if (!childPatchVersions.isEmpty()) {
            return ServiceResponse.fail((String)"\u5b58\u5728\u57fa\u4e8e\u6b64\u7248\u672c\u6253\u51fa\u7684\u8865\u4e01\u7248\u672c\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return this.doRemoveAppVersion(appVersion);
    }

    @Override
    public IPage<Bo> queryBos(XfPage page, QueryBoVo queryBoVo) {
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(queryBoVo.getAppId(), queryBoVo.getAppVersion(), ResourceType.BO);
        if (!versionChangeOptl.isPresent()) {
            return new XfPage();
        }
        Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(queryBoVo.getAppId().longValue(), versionChangeOptl.get().getResourceVersion());
        if (!moduleOptl.isPresent()) {
            return new XfPage();
        }
        queryBoVo.setModuleId(((Module)moduleOptl.get()).getPublishModuleId());
        queryBoVo.setModuleVersion(versionChangeOptl.get().getResourceVersion());
        return this.moduleInfoExService.queryBos(page, queryBoVo);
    }

    @Override
    public ServiceResponse getDicts(Long appId, String version) {
        List<Dict> dicts = this.dictVersionQuery.getDicts(appId, version);
        if (dicts.isEmpty()) {
            return ServiceResponse.success((String)"", (Object)Lists.newArrayList());
        }
        Map<Long, List<DictDetail>> dictDetailsMap = this.dictDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictDetail::getDeleteFlag, (Object)"1")).in(DictDetail::getDictId, (Collection)dicts.stream().map(Dict::getId).collect(Collectors.toList()))).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        List dictVos = dicts.stream().map(dt -> {
            DictVo dictVo = DictStructMapper.MAPPER.toVo(dt);
            Optional.ofNullable(dictDetailsMap.get(dt.getId())).ifPresent(dictDetails -> dictVo.setOptions(dictDetails.stream().map(op -> CommonBusiness.convertDictDetailToVo((DictDetail)op)).collect(Collectors.toList())));
            return dictVo;
        }).collect(Collectors.toList());
        return ServiceResponse.success((String)"", dictVos);
    }

    private ServiceResponse doRemoveAppVersion(AppVersion appVersion) throws InterruptedException {
        if (null == appVersion) {
            return ServiceResponse.fail((String)"\u5e94\u7528\u7248\u672c\u4e0d\u5b58\u5728");
        }
        List appVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AppVersionChange::getAppVersionId, (Object)appVersion.getId())).eq(AppVersionChange::getDeleteFlag, (Object)"1")).isNotNull(AppVersionChange::getResourceVersion));
        CountDownLatch latch = new CountDownLatch(7);
        TtlRunnable.get(() -> {
            Optional<AppVersionChange> changeOptl = appVersionChanges.stream().filter(versionChange -> ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) && ResourceType.BO.code().equals(versionChange.getResourceType())).findAny();
            changeOptl.ifPresent(versionChange -> {
                Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(appVersion.getAppId().longValue(), versionChange.getResourceVersion());
                moduleOptl.ifPresent(module -> this.moduleInfoExService.removeById(module.getId()));
                Module module2 = new Module();
                module2.setId(versionChange.getResourceId());
                module2.setVersion(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion());
                this.moduleService.updateById((Object)module2);
            });
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u5bf9\u8c61\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            Optional<AppVersionChange> changeOptl = appVersionChanges.stream().filter(versionChange -> ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) && ResourceType.DICT.code().equals(versionChange.getResourceType())).findAny();
            changeOptl.ifPresent(versionChange -> {
                this.removeDicts(appVersion.getAppId(), versionChange.getResourceVersion());
                if (AppVersionType.PATCH.code().equals(appVersion.getVersionType())) {
                    Dict dict = new Dict();
                    dict.setVersion(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion());
                    this.dictService.update((Object)dict, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(Dict::getAppId, (Object)appVersion.getAppId())).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
                }
            });
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u5b57\u5178\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            List<AppVersionChange> versionChanges = appVersionChanges.stream().filter(versionChange -> ResourceType.PAGE.code().equals(versionChange.getResourceType()) && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
            this.removePagesByVersion(appVersion.getAppId(), versionChanges);
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u9875\u9762\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            List<AppVersionChange> versionChanges = appVersionChanges.stream().filter(versionChange -> ResourceType.FORM.code().equals(versionChange.getResourceType()) && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
            this.removeFormsByVersion(appVersion.getAppId(), versionChanges);
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u8868\u5355\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            Optional<AppVersionChange> changeOptl = appVersionChanges.stream().filter(versionChange -> ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) && ResourceType.FLOW_ACTION.code().equals(versionChange.getResourceType())).findAny();
            changeOptl.ifPresent(versionChange -> {
                this.removeFlowActions(appVersion.getAppId(), versionChange.getResourceVersion());
                FlowAction flowAction = new FlowAction();
                flowAction.setVersion(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion());
                this.flowActionService.update((Object)flowAction, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FlowAction::getAppId, (Object)appVersion.getAppId())).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId)).set(FlowAction::getVersion, (Object)(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion())));
            });
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u6d41\u52a8\u4f5c\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            List<AppVersionChange> versionChanges = appVersionChanges.stream().filter(versionChange -> ResourceType.FLOW_SETTING.code().equals(versionChange.getResourceType()) && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
            this.removeFlowSettingsByVersion(appVersion.getAppId(), versionChanges);
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u6d41\u8bbe\u7f6e\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            Optional<AppVersionChange> changeOptl = appVersionChanges.stream().filter(versionChange -> ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) && ResourceType.API.code().equals(versionChange.getResourceType())).findAny();
            changeOptl.ifPresent(versionChange -> {
                this.removeApisByVersion(appVersion.getAppId(), versionChange.getResourceVersion());
                this.apisService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(Apis::getApplicationId, (Object)appVersion.getAppId())).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).set(Apis::getVersion, (Object)(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion())));
            });
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u63a5\u53e3\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        TtlRunnable.get(() -> {
            Optional<AppVersionChange> changeOptl = appVersionChanges.stream().filter(versionChange -> ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) && ResourceType.APP_EVENT.code().equals(versionChange.getResourceType())).findAny();
            changeOptl.ifPresent(versionChange -> {
                this.removeAppEventByVersion(appVersion.getAppId(), versionChange.getResourceVersion());
                this.appEventService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AppEvent::getAppId, (Object)appVersion.getAppId())).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).set(AppEvent::getVersion, (Object)(StringUtils.isEmpty((CharSequence)versionChange.getOriginResourceVersion()) ? "0.0.0" : versionChange.getOriginResourceVersion())));
            });
            log.debug("\u5e94\u7528{}\u7248\u672c{}\u5220\u9664\u5e94\u7528\u4e8b\u4ef6\u7248\u672c\u6210\u529f", (Object)appVersion.getAppId(), (Object)appVersion.getVersion());
            latch.countDown();
        }).run();
        latch.await();
        appVersion.setDeleteFlag("0");
        appVersionChanges.forEach(versionChange -> versionChange.setDeleteFlag("0"));
        this.appVersionService.updateById((Object)appVersion);
        if (!appVersionChanges.isEmpty()) {
            this.appVersionChangeService.updateBatchById((Collection)appVersionChanges);
        }
        log.debug("\u5220\u9664\u5e94\u7528\u8865\u4e01\u7248\u672c\u6210\u529f");
        return ServiceResponse.success();
    }

    private ServiceResponse removeDicts(Long appId, String version) {
        LambdaQueryWrapper dictWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getDeleteFlag, (Object)"1");
        if (StringUtils.isEmpty((CharSequence)version)) {
            dictWrapper.eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
        } else {
            ((LambdaQueryWrapper)dictWrapper.eq(Dict::getVersion, (Object)version)).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        }
        List dicts = this.dictService.list((Wrapper)dictWrapper);
        if (dicts.isEmpty()) {
            return ServiceResponse.success((String)"");
        }
        List dictIds = dicts.stream().map(Dict::getId).collect(Collectors.toList());
        DictDetail dictDetail = new DictDetail().setDeleteFlag("0");
        this.dictDetailService.update((Object)dictDetail, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(DictDetail::getDeleteFlag, (Object)"1")).in(DictDetail::getDictId, dictIds));
        dicts.forEach(dict -> dict.setDeleteFlag("0"));
        this.dictService.updateBatchById((Collection)dicts);
        return ServiceResponse.success();
    }

    private ServiceResponse removePagesByVersion(Long appId, List<AppVersionChange> versionChanges) {
        ArrayList pUltPageIds;
        List filterVersionChanges = versionChanges.stream().filter(versionChange -> versionChange.getResourceId() != null && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> filterVersionChanges.stream().forEach(versionChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPage::getPublishRefPageId, (Object)versionChange.getResourceId())).eq(UltPage::getVersion, (Object)versionChange.getResourceVersion());
            });
        }));
        List<Object> list = pUltPageIds = filterVersionChanges.isEmpty() ? Lists.newArrayList() : this.ultPageMapper.selectList((Wrapper)wrapper).stream().map(UltPage::getId).collect(Collectors.toList());
        if (pUltPageIds.isEmpty()) {
            return ServiceResponse.success();
        }
        UltPage ultPage = new UltPage().setDeleteFlag("0");
        this.ultPageMapper.update((Object)ultPage, (Wrapper)Wrappers.lambdaQuery().in(UltPage::getId, (Collection)pUltPageIds));
        PageBoSetting pageBoSetting = new PageBoSetting().setDeleteFlag("0");
        this.pageBoSettingMapper.update((Object)pageBoSetting, (Wrapper)Wrappers.lambdaQuery().in(PageBoSetting::getPageId, (Collection)pUltPageIds));
        return ServiceResponse.success();
    }

    private ServiceResponse removeFormsByVersion(Long appId, List<AppVersionChange> versionChanges) {
        List filterVersionChanges = versionChanges.stream().filter(versionChange -> versionChange.getResourceId() != null && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
        if (filterVersionChanges.isEmpty()) {
            return ServiceResponse.success();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> filterVersionChanges.stream().forEach(versionChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)versionChange.getResourceId())).eq(UltForm::getVersion, (Object)versionChange.getResourceVersion());
            });
        }));
        List pUltFormIds = this.ultFormMapper.selectList((Wrapper)wrapper).stream().map(UltForm::getId).collect(Collectors.toList());
        if (pUltFormIds.isEmpty()) {
            return ServiceResponse.success();
        }
        UltForm ultForm = new UltForm().setDeleteFlag("0");
        this.ultFormMapper.update((Object)ultForm, (Wrapper)Wrappers.lambdaQuery().in(UltForm::getId, pUltFormIds));
        return ServiceResponse.success();
    }

    private ServiceResponse removeFlowActions(Long appId, String version) {
        List flowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getVersion, (Object)version)).isNotNull(FlowAction::getPublishActionId)).eq(FlowAction::getDeleteFlag, (Object)"1"));
        if (flowActions.isEmpty()) {
            return ServiceResponse.success();
        }
        flowActions.forEach(flowAction -> flowAction.setDeleteFlag("0"));
        this.flowActionService.updateBatchById((Collection)flowActions);
        List actionIds = flowActions.stream().map(FlowAction::getId).collect(Collectors.toList());
        this.flowActionParamService.remove((Wrapper)Wrappers.lambdaUpdate().in(FlowActionParam::getActionId, actionIds));
        return ServiceResponse.success();
    }

    private ServiceResponse removeFlowSettingsByVersion(Long appId, List<AppVersionChange> versionChanges) {
        List filterVersionChanges = versionChanges.stream().filter(versionChange -> versionChange.getResourceId() != null && (ChangeFlag.CHANGED.code().equals(versionChange.getChangeFlag()) || !versionChange.getResourceVersion().equals(versionChange.getOriginResourceVersion()))).collect(Collectors.toList());
        if (filterVersionChanges.isEmpty()) {
            return ServiceResponse.success();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{FlowSetting::getId}).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        wrapper.and(w -> filterVersionChanges.stream().forEach(versionChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlowId, (Object)versionChange.getResourceId())).eq(FlowSetting::getVersion, (Object)versionChange.getResourceVersion());
            });
        }));
        List pFlowSettingIds = this.flowSettingService.list((Wrapper)wrapper).stream().map(FlowSetting::getId).collect(Collectors.toList());
        if (pFlowSettingIds.isEmpty()) {
            return ServiceResponse.success();
        }
        FlowSetting flowSetting = new FlowSetting().setDeleteFlag("0");
        this.flowSettingService.update((Object)flowSetting, (Wrapper)Wrappers.lambdaQuery().in(FlowSetting::getId, pFlowSettingIds));
        return ServiceResponse.success();
    }

    private ServiceResponse removeApisByVersion(Long appId, String version) {
        List apis = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getVersion, (Object)version)).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Apis::getDeleteFlag, (Object)"1"));
        if (apis.isEmpty()) {
            return ServiceResponse.success();
        }
        apis.forEach(flowAction -> flowAction.setDeleteFlag("0"));
        this.apisService.updateBatchById((Collection)apis);
        return ServiceResponse.success();
    }

    private ServiceResponse removeAppEventByVersion(Long appId, String version) {
        List appEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getVersion, (Object)version)).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(AppEvent::getDeleteFlag, (Object)"1"));
        if (appEvents.isEmpty()) {
            return ServiceResponse.success();
        }
        appEvents.forEach(appEvent -> appEvent.setDeleteFlag("0"));
        this.appEventService.updateBatchById((Collection)appEvents);
        return ServiceResponse.success();
    }
}

