/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppType;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PackageFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.VersionStatus;
import com.xforceplus.ultraman.bocp.metadata.exception.ServiceException;
import com.xforceplus.ultraman.bocp.metadata.infra.util.UserUtils;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ResourceType;
import com.xforceplus.ultraman.bocp.metadata.version.event.NewSolutionUploadOSSEvent;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionPublishAggregator;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppPublishService;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionExService;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionPublishService;
import com.xforceplus.ultraman.bocp.metadata.version.vo.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEventRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SdkSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueTagRepository;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xforceplus.ultraman.pfcp.setting.entity.UltForm;
import com.xforceplus.ultraman.pfcp.setting.entity.UltPage;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppVersionPublishServiceImpl
implements IAppVersionPublishService {
    private static final Logger log = LoggerFactory.getLogger(AppVersionPublishServiceImpl.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IApisService apisService;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private ISueRuleService sueRuleService;
    @Autowired
    private ISueTagService sueTagService;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private ISdkSettingService sdkSettingService;
    @Autowired
    private IAppPublishService appPublishService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private IAppVersionExService appVersionExService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private ApisRepository apisRepository;
    @Autowired
    private SueRuleRepository sueRuleRepository;
    @Autowired
    private SueTagRepository sueTagRepository;
    @Autowired
    private AppEventRepository appEventRepository;
    @Autowired
    private FlowActionRepository flowActionRepository;
    @Autowired
    private SdkSettingRepository sdkSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;
    @Autowired
    private VersionPublishAggregator versionPublishAggregator;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TransactionDefinition transactionDefinition;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public ServiceResponse publishAppVersion(PublishContent publishContent) {
        String newVersion = this.appVersionExService.getNewAppVersion(publishContent.getAppId(), publishContent.getVersionType());
        if (StringUtils.isEmpty((CharSequence)newVersion)) {
            return ServiceResponse.fail((String)"\u83b7\u53d6\u4e0d\u5230\u65b0\u7248\u672c\u4fe1\u606f");
        }
        ServiceResponse serviceResponse = this.appPublishService.checkPublishContent(publishContent.getAppId(), publishContent);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersion(publishContent.getAppId()).orElse(null);
        log.debug("\u5e94\u7528\u6574\u4f53\u53d1\u5e03 start");
        AppVersion nAppVersion = new AppVersion();
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        try {
            AppVersionChange sdkSettingVersionChange;
            AppVersionChange appEventVersionChange;
            AppVersionChange tagVersionChange;
            AppVersionChange ruleVersionChange;
            AppVersionChange dictVersionChange;
            AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
            ArrayList appVersionChanges = Lists.newArrayList();
            AppVersionChange moduleVersionChange = this.handleBoPublish(appVersion, publishContent, newVersion);
            if (moduleVersionChange != null) {
                appVersionChanges.add(moduleVersionChange);
            }
            if ((dictVersionChange = this.handleDictPublish(appVersion, publishContent, newVersion)) != null) {
                dictVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(dictVersionChange);
            }
            appVersionChanges.addAll(this.handlePagePublish(publishContent.getAppId(), appVersionType, publishContent.getPageChanges(), publishContent.getRemark()));
            appVersionChanges.addAll(this.handleFormPublish(publishContent.getAppId(), appVersionType, publishContent.getFormChanges(), publishContent.getRemark()));
            AppVersionChange flowActionVersionChange = this.handleFlowActionPublish(appVersion, publishContent, newVersion);
            if (flowActionVersionChange != null) {
                flowActionVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(flowActionVersionChange);
            }
            appVersionChanges.addAll(this.handleFlowSettingPublish(publishContent.getAppId(), appVersionType, publishContent.getFlowSettingChanges(), publishContent.getRemark()));
            AppVersionChange apiVersionChange = this.handleApisPublish(appVersion, publishContent, newVersion);
            if (apiVersionChange != null) {
                apiVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(apiVersionChange);
            }
            if ((ruleVersionChange = this.handleRulePublish(appVersion, publishContent, newVersion)) != null) {
                ruleVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(ruleVersionChange);
            }
            if ((tagVersionChange = this.handleTagPublish(appVersion, publishContent, newVersion)) != null) {
                tagVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(tagVersionChange);
            }
            if ((appEventVersionChange = this.handleAppEventPublish(appVersion, publishContent, newVersion)) != null) {
                appEventVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(appEventVersionChange);
            }
            if ((sdkSettingVersionChange = this.handleSdkSettingPublish(appVersion, publishContent, newVersion)) != null) {
                sdkSettingVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(sdkSettingVersionChange);
            }
            nAppVersion.setAppId(publishContent.getAppId()).setVersion(newVersion).setVersionType(appVersionType.code()).setVersionStatus(VersionStatus.TEST.code()).setRemark(publishContent.getRemark()).setPublisherId(UserUtils.getUserId()).setPublisherName(UserUtils.getUsername()).setPublishTime(LocalDateTime.now()).setPackageFlag(PackageFlag.NO_PACKAGE.code());
            this.appVersionService.save((Object)nAppVersion);
            appVersionChanges.forEach(avc -> avc.setAppVersionId(nAppVersion.getId()));
            this.appVersionChangeService.saveBatch((Collection)appVersionChanges);
            this.transactionManager.commit(transactionStatus);
            log.debug("\u5e94\u7528\u6574\u4f53\u53d1\u5e03 end");
        }
        catch (ServiceException se) {
            this.transactionManager.rollback(transactionStatus);
            log.error("\u4e1a\u52a1\u903b\u8f91\u95ee\u9898", (Throwable)se);
            return ServiceResponse.fail((String)se.getMessage());
        }
        catch (Exception e) {
            this.transactionManager.rollback(transactionStatus);
            log.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            return ServiceResponse.fail((String)("\u7cfb\u7edf\u5f02\u5e38 " + e.getMessage()));
        }
        Optional appOptl = this.appRepository.getApp(publishContent.getAppId().longValue());
        if (appOptl.isPresent() && AppType.NEW_CLOUD.code().equals(((App)appOptl.get()).getType())) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewSolutionUploadOSSEvent(this, nAppVersion.getId()));
        }
        return ServiceResponse.success((String)"\u53d1\u5e03\u6210\u529f", (Object)nAppVersion);
    }

    @Override
    public ServiceResponse publishAppPatchVersion(Long appVersionId, PublishContent publishContent) {
        String newVersion = this.appVersionExService.getNewAppPatchVersion(publishContent.getAppId(), appVersionId);
        if (StringUtils.isEmpty((CharSequence)newVersion)) {
            return ServiceResponse.fail((String)"\u83b7\u53d6\u4e0d\u5230\u65b0\u7248\u672c\u4fe1\u606f");
        }
        AppVersion appVersion = this.appVersionQuery.getAppVersion(publishContent.getAppId(), appVersionId).orElse(null);
        if (null == appVersion) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u4e3b\u7248\u672c\u4fe1\u606f");
        }
        publishContent.setVersionType(AppVersionType.PATCH.code());
        AppVersion nAppVersion = new AppVersion();
        log.debug("\u5e94\u7528\u8865\u4e01\u6574\u4f53\u53d1\u5e03 start");
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        try {
            AppVersionChange appEventVersionChange;
            AppVersionChange tagVersionChange;
            AppVersionChange ruleVersionChange;
            AppVersionChange dictVersionChange;
            ArrayList appVersionChanges = Lists.newArrayList();
            AppVersionChange moduleVersionChange = this.handleBoPublishPatch(appVersion, publishContent, newVersion);
            if (moduleVersionChange != null) {
                appVersionChanges.add(moduleVersionChange);
            }
            if ((dictVersionChange = this.handleDictPublishPatch(appVersion, publishContent, newVersion)) != null) {
                dictVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(dictVersionChange);
            }
            appVersionChanges.addAll(this.handlePagePublishPatch(appVersion, publishContent, newVersion));
            appVersionChanges.addAll(this.handleFormPublishPatch(appVersion, publishContent, newVersion));
            AppVersionChange flowActionVersionChange = this.handleFlowActionPublishPatch(appVersion, publishContent, newVersion);
            if (flowActionVersionChange != null) {
                flowActionVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(flowActionVersionChange);
            }
            appVersionChanges.addAll(this.handleFlowSettingPublishPatch(appVersion, publishContent, newVersion));
            AppVersionChange apiVersionChange = this.handleApisPublishPatch(appVersion, publishContent, newVersion);
            if (apiVersionChange != null) {
                apiVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(apiVersionChange);
            }
            if ((ruleVersionChange = this.handleRulePublishPatch(appVersion, publishContent, newVersion)) != null) {
                ruleVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(ruleVersionChange);
            }
            if ((tagVersionChange = this.handleTagPublishPatch(appVersion, publishContent, newVersion)) != null) {
                tagVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(tagVersionChange);
            }
            if ((appEventVersionChange = this.handleAppEventPublishPatch(appVersion, publishContent, newVersion)) != null) {
                appEventVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(appEventVersionChange);
            }
            AppVersionChange sdkSettingVersionChange = this.handleSdkSettingPublishPatch(appVersion, publishContent, newVersion);
            if (appEventVersionChange != null) {
                appEventVersionChange.setResourceId(publishContent.getAppId());
                appVersionChanges.add(sdkSettingVersionChange);
            }
            Long mainVersionId = AppVersionType.PATCH.code().equals(appVersion.getVersionType()) ? appVersion.getMainVersionId() : appVersionId;
            nAppVersion.setAppId(publishContent.getAppId()).setVersion(newVersion).setMainVersionId(mainVersionId).setParentVersionId(appVersionId).setVersionType(AppVersionType.PATCH.code()).setVersionStatus(VersionStatus.TEST.code()).setRemark(publishContent.getRemark()).setPublisherId(UserUtils.getUserId()).setPublisherName(UserUtils.getUsername()).setPublishTime(LocalDateTime.now()).setPackageFlag(PackageFlag.NO_PACKAGE.code());
            this.appVersionService.save((Object)nAppVersion);
            appVersionChanges.forEach(avc -> avc.setAppVersionId(nAppVersion.getId()));
            this.appVersionChangeService.saveBatch((Collection)appVersionChanges);
            this.transactionManager.commit(transactionStatus);
            log.debug("\u5e94\u7528\u8865\u4e01\u6574\u4f53\u53d1\u5e03 end");
        }
        catch (ServiceException se) {
            this.transactionManager.rollback(transactionStatus);
            log.error("\u5e94\u7528\u8865\u4e01\u6574\u4f53\u53d1\u5e03\u4e1a\u52a1\u903b\u8f91\u95ee\u9898", (Throwable)se);
            return ServiceResponse.fail((String)se.getMessage());
        }
        catch (Exception e) {
            this.transactionManager.rollback(transactionStatus);
            log.error("\u5e94\u7528\u8865\u4e01\u6574\u4f53\u53d1\u5e03\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            return ServiceResponse.fail((String)("\u7cfb\u7edf\u5f02\u5e38 " + e.getMessage()));
        }
        Optional appOptl = this.appRepository.getApp(publishContent.getAppId().longValue());
        if (appOptl.isPresent() && AppType.NEW_CLOUD.code().equals(((App)appOptl.get()).getType())) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new NewSolutionUploadOSSEvent(this, nAppVersion.getId()));
        }
        return ServiceResponse.success((String)"\u53d1\u5e03\u6210\u529f", (Object)nAppVersion);
    }

    @Override
    public ServiceResponse publishBo(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishBo(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishDict(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishDict(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishPage(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishPage(appId, appVersionType, changedItems, publishRemark, null, null);
    }

    @Override
    public ServiceResponse publishForm(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishForm(appId, appVersionType, changedItems, publishRemark, null, null);
    }

    @Override
    public ServiceResponse publishFlowAction(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishFlowAction(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishFlowSetting(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishFlowSetting(appId, appVersionType, changedItems, publishRemark, null, null);
    }

    @Override
    public ServiceResponse publishApi(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishApi(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishRule(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishRule(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishTag(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishTag(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishAppEvent(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishAppEvent(nVersion, originVersion, publishContent);
    }

    @Override
    public ServiceResponse publishSdkSetting(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishSdkSetting(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishBoPatch(String nVersion, String originModuleVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishBo(nVersion, originModuleVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishDictPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishDict(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishPagePatch(Long appId, String nVersion, String originVersion, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishPage(appId, AppVersionType.PATCH, changedItems, publishRemark, nVersion, originVersion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishFormPatch(Long appId, String nVersion, String originVersion, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishForm(appId, AppVersionType.PATCH, changedItems, publishRemark, nVersion, originVersion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishFlowActionPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishFlowAction(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishFlowSettingPatch(Long appId, String nVersion, String originVersion, List<ChangedItem> changedItems, String publishRemark) {
        return this.versionPublishAggregator.publishFlowSetting(appId, AppVersionType.PATCH, changedItems, publishRemark, nVersion, originVersion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishApiPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishApi(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishRulePatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishRule(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishTagPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishTag(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishAppEventPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishAppEvent(nVersion, originVersion, publishContent);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse publishSdkSettingPatch(String nVersion, String originVersion, PublishContent publishContent) {
        return this.versionPublishAggregator.publishTag(nVersion, originVersion, publishContent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AppVersionChange handleBoPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional uModuleOptional = this.defaultModuleService.getModule(publishContent.getAppId().longValue());
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.BO.code()).setResourceId(((Module)uModuleOptional.get()).getId());
        if (currentAppVersion != null) {
            Optional<AppVersionChange> boVersionChangeOptl = this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.BO);
            if (!boVersionChangeOptl.isPresent()) throw ServiceException.businessFail((String)"\u4e0a\u4e00\u4e2a\u5e94\u7528\u7248\u672c\u5b58\u5728\uff0c\u4f46\u662f\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8c61\u7248\u672c\u53d8\u66f4\u4fe1\u606f");
            appVersionChange.setOriginResourceVersion(boVersionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getBoChanges())) {
                this.publishBo(newVersion, boVersionChangeOptl.get().getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getBoChanges()));
                return appVersionChange;
            } else {
                appVersionChange.setResourceVersion(boVersionChangeOptl.get().getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
            return appVersionChange;
        } else {
            Optional pModuleOptl = this.defaultModuleService.getPublishedModuleByAppId(publishContent.getAppId().longValue(), ((Module)uModuleOptional.get()).getVersion());
            if (pModuleOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((Module)uModuleOptional.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getBoChanges())) {
                    this.publishBo(newVersion, ((Module)uModuleOptional.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getBoChanges()));
                    return appVersionChange;
                } else {
                    appVersionChange.setResourceVersion(((Module)uModuleOptional.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
                return appVersionChange;
            } else {
                appVersionChange.setOriginResourceVersion(null);
                appVersionChange.setResourceVersion(newVersion);
                this.publishBo(newVersion, ((Module)uModuleOptional.get()).getVersion(), publishContent);
                if (CollectionUtils.isNotEmpty(publishContent.getBoChanges())) {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getBoChanges()));
                    return appVersionChange;
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleDictPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional dictVersionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.DICT.code());
        Optional<Object> optional = dictVersionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.DICT);
        if (currentAppVersion != null && dictVersionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)dictVersionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getDictChanges())) {
                this.publishDict(newVersion, ((AppVersionChange)dictVersionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getDictChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)dictVersionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uDictOptl = this.dictRepository.getDicts(publishContent.getAppId()).stream().findAny();
            if (uDictOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((Dict)uDictOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getDictChanges())) {
                    this.publishDict(newVersion, ((Dict)uDictOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getDictChanges()));
                } else {
                    Optional pDictOptl = this.metadataVersionQuery.getDicts(publishContent.getAppId(), ((Dict)uDictOptl.get()).getVersion()).stream().findAny();
                    if (!pDictOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((Dict)uDictOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pDictOptl = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)publishContent.getAppId())).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(Dict::getId)).stream().findAny();
                if (!pDictOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((Dict)pDictOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getDictChanges()));
            }
        }
        return appVersionChange;
    }

    private List<AppVersionChange> handlePagePublish(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) throws ServiceException {
        ArrayList appVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(changedItems)) {
            ServiceResponse response = this.publishPage(appId, appVersionType, changedItems, publishRemark);
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.PAGE.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = changedItems.stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                appVersionChanges.add(appVersionChange);
            });
            ArrayList pageIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = changedItems.stream().filter(item -> !pageIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.PAGE.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                appVersionChanges.add(appVersionChange);
            }
        } else {
            AppVersion lastAppVersion = this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
            if (lastAppVersion == null) {
                List<UltPage> ultPages = this.metadataVersionQuery.getLatestVersionPages(appId);
                ultPages.forEach(ultPage -> {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.PAGE.code());
                    appVersionChange.setResourceId(ultPage.getPublishRefPageId());
                    appVersionChange.setOriginResourceVersion(ultPage.getVersion());
                    appVersionChange.setResourceVersion(ultPage.getVersion());
                    appVersionChanges.add(appVersionChange);
                });
            } else {
                List lastAppVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)lastAppVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.PAGE.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
                lastAppVersionChanges.forEach(versionChange -> {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.PAGE.code());
                    appVersionChange.setResourceId(versionChange.getResourceId());
                    appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                    appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                    appVersionChanges.add(appVersionChange);
                });
            }
        }
        return appVersionChanges;
    }

    private List<AppVersionChange> handleFormPublish(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) throws ServiceException {
        ArrayList appVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(changedItems)) {
            ServiceResponse response = this.publishForm(appId, appVersionType, changedItems, publishRemark);
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FORM.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = changedItems.stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                appVersionChanges.add(appVersionChange);
            });
            ArrayList formIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = changedItems.stream().filter(item -> !formIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FORM.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                appVersionChanges.add(appVersionChange);
            }
        } else {
            AppVersion lastAppVersion = this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
            if (lastAppVersion == null) {
                List<UltForm> ultForms = this.metadataVersionQuery.getLatestVersionForms(appId);
                ultForms.forEach(ultForm -> {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.FORM.code());
                    appVersionChange.setResourceId(ultForm.getPublishRefFormId());
                    appVersionChange.setOriginResourceVersion(ultForm.getVersion());
                    appVersionChange.setResourceVersion(ultForm.getVersion());
                    appVersionChanges.add(appVersionChange);
                });
            } else {
                List lastAppVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)lastAppVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.FORM.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
                lastAppVersionChanges.forEach(versionChange -> {
                    if (versionChange.getResourceId() != null) {
                        AppVersionChange appVersionChange = new AppVersionChange();
                        appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                        appVersionChange.setResourceType(ResourceType.FORM.code());
                        appVersionChange.setResourceId(versionChange.getResourceId());
                        appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                        appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                        appVersionChanges.add(appVersionChange);
                    }
                });
            }
        }
        return appVersionChanges;
    }

    private AppVersionChange handleFlowActionPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.FLOW_ACTION.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.FLOW_ACTION);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getFlowActionChanges())) {
                this.publishFlowAction(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getFlowActionChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uOptl = this.flowActionRepository.getFlowActions(publishContent.getAppId()).stream().findAny();
            if (uOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((FlowAction)uOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getFlowActionChanges())) {
                    this.publishFlowAction(newVersion, ((FlowAction)uOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getFlowActionChanges()));
                } else {
                    Optional pOptl = this.metadataVersionQuery.getFlowActions(publishContent.getAppId(), ((FlowAction)uOptl.get()).getVersion()).stream().findAny();
                    if (!pOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((FlowAction)uOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pOptl = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)publishContent.getAppId())).eq(FlowAction::getDeleteFlag, (Object)"1")).isNotNull(FlowAction::getPublishActionId)).orderByDesc(FlowAction::getId)).stream().findAny();
                if (!pOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((FlowAction)pOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getFlowActionChanges()));
            }
        }
        return appVersionChange;
    }

    private List<AppVersionChange> handleFlowSettingPublish(Long appId, AppVersionType appVersionType, List<ChangedItem> changedItems, String publishRemark) throws ServiceException {
        ArrayList appVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(changedItems)) {
            ServiceResponse response = this.publishFlowSetting(appId, appVersionType, changedItems, publishRemark);
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = changedItems.stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                appVersionChanges.add(appVersionChange);
            });
            ArrayList flowSettingIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = changedItems.stream().filter(item -> !flowSettingIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                appVersionChanges.add(appVersionChange);
            }
        } else {
            AppVersion lastAppVersion = this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
            if (lastAppVersion == null) {
                List<FlowSetting> ultFlowSettings = this.metadataVersionQuery.getLatestVersionFlowSettings(appId);
                ultFlowSettings.forEach(ultFlowSetting -> {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                    appVersionChange.setResourceId(ultFlowSetting.getPublishFlowId());
                    appVersionChange.setOriginResourceVersion(ultFlowSetting.getVersion());
                    appVersionChange.setResourceVersion(ultFlowSetting.getVersion());
                    appVersionChanges.add(appVersionChange);
                });
            } else {
                List lastAppVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)lastAppVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.FLOW_SETTING.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
                lastAppVersionChanges.forEach(versionChange -> {
                    if (versionChange.getResourceId() != null) {
                        AppVersionChange appVersionChange = new AppVersionChange();
                        appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                        appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                        appVersionChange.setResourceId(versionChange.getResourceId());
                        appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                        appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                        appVersionChanges.add(appVersionChange);
                    }
                });
            }
        }
        return appVersionChanges;
    }

    private AppVersionChange handleApisPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.API.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.API);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getApiChanges())) {
                this.publishApi(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getApiChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uApisOptl = this.apisRepository.getApis(publishContent.getAppId()).stream().findAny();
            if (uApisOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((Apis)uApisOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getApiChanges())) {
                    this.publishApi(newVersion, ((Apis)uApisOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getApiChanges()));
                } else {
                    Optional pApisOptl = this.metadataVersionQuery.getApis(publishContent.getAppId(), ((Apis)uApisOptl.get()).getVersion()).stream().findAny();
                    if (!pApisOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((Apis)uApisOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pApisOptl = this.apisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)publishContent.getAppId())).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(Apis::getId)).stream().findAny();
                if (!pApisOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((Apis)pApisOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getApiChanges()));
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleRulePublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.RULE.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.RULE);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getRuleChanges())) {
                this.publishRule(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getRuleChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uOptl = this.sueRuleRepository.getSueRules(publishContent.getAppId()).stream().findAny();
            if (uOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((SueRule)uOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getRuleChanges())) {
                    this.publishRule(newVersion, ((SueRule)uOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getRuleChanges()));
                } else {
                    Optional pOptl = this.metadataVersionQuery.getRules(publishContent.getAppId(), ((SueRule)uOptl.get()).getVersion()).stream().findAny();
                    if (!pOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((SueRule)uOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pOptl = this.sueRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)publishContent.getAppId())).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(SueRule::getId)).stream().findAny();
                if (!pOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((SueRule)pOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getRuleChanges()));
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleTagPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.TAG.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.TAG);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getTagChanges())) {
                this.publishTag(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getTagChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uSueTagOptl = this.sueTagRepository.getSueTags(publishContent.getAppId()).stream().findAny();
            if (uSueTagOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((SueTag)uSueTagOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getTagChanges())) {
                    this.publishTag(newVersion, ((SueTag)uSueTagOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getTagChanges()));
                } else {
                    Optional pSueTagOptl = this.metadataVersionQuery.getTags(publishContent.getAppId(), ((SueTag)uSueTagOptl.get()).getVersion()).stream().findAny();
                    if (!pSueTagOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((SueTag)uSueTagOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pSueTagOptl = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)publishContent.getAppId())).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(SueTag::getId)).stream().findAny();
                if (!pSueTagOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((SueTag)pSueTagOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getTagChanges()));
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleAppEventPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.APP_EVENT.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.APP_EVENT);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getAppEventChanges())) {
                this.publishAppEvent(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getAppEventChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uAppEventOptl = this.appEventRepository.getAppEvents(publishContent.getAppId()).stream().findAny();
            if (uAppEventOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((AppEvent)uAppEventOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getAppEventChanges())) {
                    this.publishAppEvent(newVersion, ((AppEvent)uAppEventOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getAppEventChanges()));
                } else {
                    Optional pAppEventOptl = this.metadataVersionQuery.getAppEvents(publishContent.getAppId(), ((AppEvent)uAppEventOptl.get()).getVersion()).stream().findAny();
                    if (!pAppEventOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((AppEvent)uAppEventOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pAppEventOptl = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)publishContent.getAppId())).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(AppEvent::getId)).stream().findAny();
                if (!pAppEventOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((AppEvent)pAppEventOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getAppEventChanges()));
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleSdkSettingPublish(AppVersion currentAppVersion, PublishContent publishContent, String newVersion) throws ServiceException {
        Optional versionChangeOptl;
        AppVersionChange appVersionChange = new AppVersionChange().setResourceType(ResourceType.SDK_SETTING.code());
        Optional<Object> optional = versionChangeOptl = currentAppVersion == null ? Optional.empty() : this.appVersionQuery.getAppVersionChange(currentAppVersion.getId(), ResourceType.SDK_SETTING);
        if (currentAppVersion != null && versionChangeOptl.isPresent()) {
            appVersionChange.setOriginResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getSdkSettingChanges())) {
                this.publishSdkSetting(newVersion, ((AppVersionChange)versionChangeOptl.get()).getResourceVersion(), publishContent);
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getSdkSettingChanges()));
            } else {
                appVersionChange.setResourceVersion(((AppVersionChange)versionChangeOptl.get()).getResourceVersion());
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        } else {
            Optional uSdkSettingOptl = this.sdkSettingRepository.getSdkSettings(publishContent.getAppId()).stream().findAny();
            if (uSdkSettingOptl.isPresent()) {
                appVersionChange.setOriginResourceVersion(((SdkSetting)uSdkSettingOptl.get()).getVersion());
                if (CollectionUtils.isNotEmpty(publishContent.getSdkSettingChanges())) {
                    this.publishSdkSetting(newVersion, ((SdkSetting)uSdkSettingOptl.get()).getVersion(), publishContent);
                    appVersionChange.setResourceVersion(newVersion);
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getSdkSettingChanges()));
                } else {
                    Optional pSdkSettingOptl = this.metadataVersionQuery.getSdkSettings(publishContent.getAppId(), ((SdkSetting)uSdkSettingOptl.get()).getVersion()).stream().findAny();
                    if (!pSdkSettingOptl.isPresent()) {
                        return null;
                    }
                    appVersionChange.setResourceVersion(((SdkSetting)uSdkSettingOptl.get()).getVersion());
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                }
            } else {
                Optional pSdkSettingOptl = this.sdkSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)publishContent.getAppId())).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(SdkSetting::getId)).stream().findAny();
                if (!pSdkSettingOptl.isPresent()) {
                    return null;
                }
                appVersionChange.setOriginResourceVersion(((SdkSetting)pSdkSettingOptl.get()).getVersion());
                appVersionChange.setResourceVersion(newVersion);
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(publishContent.getSdkSettingChanges()));
            }
        }
        return appVersionChange;
    }

    private AppVersionChange handleBoPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        Optional uModuleOptional = this.defaultModuleService.getModule(publishContent.getAppId().longValue());
        AppVersionChange moduleVersionChange = new AppVersionChange().setResourceType(ResourceType.BO.code()).setResourceId(((Module)uModuleOptional.get()).getId());
        Optional<AppVersionChange> boVersionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.BO);
        if (!boVersionChangeOptl.isPresent()) {
            throw ServiceException.businessFail((String)"\u5e94\u7528\u7248\u672c\u5b58\u5728\uff0c\u4f46\u662f\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8c61\u7248\u672c\u53d8\u66f4\u4fe1\u606f");
        }
        moduleVersionChange.setOriginResourceVersion(boVersionChangeOptl.get().getResourceVersion());
        if (CollectionUtils.isNotEmpty(publishContent.getBoChanges())) {
            this.publishBoPatch(newVersion, boVersionChangeOptl.get().getResourceVersion(), publishContent);
            moduleVersionChange.setResourceVersion(newVersion);
            moduleVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
            moduleVersionChange.setChangeContent(JSON.toJSONString(publishContent.getBoChanges()));
        } else {
            moduleVersionChange.setResourceVersion(boVersionChangeOptl.get().getResourceVersion());
            moduleVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
        }
        return moduleVersionChange;
    }

    private AppVersionChange handleDictPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange dictVersionChange = new AppVersionChange().setResourceType(ResourceType.DICT.code());
        Optional<AppVersionChange> dictVersionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.DICT);
        if (dictVersionChangeOptl.isPresent()) {
            dictVersionChange.setOriginResourceVersion(dictVersionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getDictChanges())) {
                this.publishDictPatch(newVersion, dictVersionChangeOptl.get().getResourceVersion(), publishContent);
                dictVersionChange.setResourceVersion(newVersion);
                dictVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                dictVersionChange.setChangeContent(JSON.toJSONString(publishContent.getDictChanges()));
            } else {
                dictVersionChange.setResourceVersion(dictVersionChangeOptl.get().getResourceVersion());
                dictVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return dictVersionChange;
    }

    private List<AppVersionChange> handlePagePublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        ArrayList pageVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(publishContent.getPageChanges())) {
            ServiceResponse response = this.publishPagePatch(publishContent.getAppId(), newVersion, appVersion.getVersion(), publishContent.getPageChanges(), publishContent.getRemark());
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.PAGE.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = publishContent.getPageChanges().stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                pageVersionChanges.add(appVersionChange);
            });
            ArrayList pageIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = publishContent.getPageChanges().stream().filter(item -> !pageIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.PAGE.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                pageVersionChanges.add(appVersionChange);
            }
        } else {
            List currentPageVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.PAGE.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
            currentPageVersionChanges.forEach(versionChange -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                appVersionChange.setResourceType(ResourceType.PAGE.code());
                appVersionChange.setResourceId(versionChange.getResourceId());
                appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                pageVersionChanges.add(appVersionChange);
            });
        }
        return pageVersionChanges;
    }

    private List<AppVersionChange> handleFormPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        ArrayList formVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(publishContent.getFormChanges())) {
            ServiceResponse response = this.publishFormPatch(publishContent.getAppId(), newVersion, appVersion.getVersion(), publishContent.getFormChanges(), publishContent.getRemark());
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FORM.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = publishContent.getFormChanges().stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                formVersionChanges.add(appVersionChange);
            });
            ArrayList formIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = publishContent.getFormChanges().stream().filter(item -> !formIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FORM.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                formVersionChanges.add(appVersionChange);
            }
        } else {
            List currentAppVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.FORM.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
            currentAppVersionChanges.forEach(versionChange -> {
                if (versionChange.getResourceId() != null) {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.FORM.code());
                    appVersionChange.setResourceId(versionChange.getResourceId());
                    appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                    appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                    formVersionChanges.add(appVersionChange);
                }
            });
        }
        return formVersionChanges;
    }

    private AppVersionChange handleFlowActionPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.FLOW_ACTION.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.FLOW_ACTION);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getFlowActionChanges())) {
                this.publishFlowActionPatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getFlowActionChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }

    private List<AppVersionChange> handleFlowSettingPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        ArrayList newVersionChanges = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(publishContent.getFlowSettingChanges())) {
            ServiceResponse response = this.publishFlowSettingPatch(publishContent.getAppId(), newVersion, appVersion.getVersion(), publishContent.getFlowSettingChanges(), publishContent.getRemark());
            if (!response.isSuccess()) {
                throw ServiceException.businessFail((String)response.getMessage());
            }
            Map versionInfos = (Map)response.getData();
            versionInfos.values().forEach(versionInfo -> {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                appVersionChange.setResourceId(versionInfo.getPublishId());
                appVersionChange.setOriginResourceVersion(versionInfo.getOriginVersion());
                appVersionChange.setResourceVersion(versionInfo.getNewVersion());
                List partChangedItems = publishContent.getFlowSettingChanges().stream().filter(item -> item.getPath().contains(versionInfo.getPublishId().toString())).collect(Collectors.toList());
                if (partChangedItems.isEmpty()) {
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                } else {
                    appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                    appVersionChange.setChangeContent(JSON.toJSONString(partChangedItems));
                }
                newVersionChanges.add(appVersionChange);
            });
            ArrayList formIds = new ArrayList(versionInfos.keySet());
            List dChangedItems = publishContent.getFlowSettingChanges().stream().filter(item -> !formIds.contains(Long.valueOf(item.getPath().split("/")[1]))).collect(Collectors.toList());
            if (!dChangedItems.isEmpty()) {
                AppVersionChange appVersionChange = new AppVersionChange();
                appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                appVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                appVersionChange.setChangeContent(JSON.toJSONString(dChangedItems));
                newVersionChanges.add(appVersionChange);
            }
        } else {
            List currentAppVersionChanges = this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersion.getId())).eq(AppVersionChange::getResourceType, (Object)ResourceType.FLOW_SETTING.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
            currentAppVersionChanges.forEach(versionChange -> {
                if (versionChange.getResourceId() != null) {
                    AppVersionChange appVersionChange = new AppVersionChange();
                    appVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
                    appVersionChange.setResourceType(ResourceType.FLOW_SETTING.code());
                    appVersionChange.setResourceId(versionChange.getResourceId());
                    appVersionChange.setOriginResourceVersion(versionChange.getResourceVersion());
                    appVersionChange.setResourceVersion(versionChange.getResourceVersion());
                    newVersionChanges.add(appVersionChange);
                }
            });
        }
        return newVersionChanges;
    }

    private AppVersionChange handleApisPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.API.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.API);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getApiChanges())) {
                this.publishApiPatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getApiChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }

    private AppVersionChange handleRulePublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.RULE.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.RULE);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getRuleChanges())) {
                this.publishRulePatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getRuleChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }

    private AppVersionChange handleTagPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.TAG.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.TAG);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getTagChanges())) {
                this.publishTagPatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getTagChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }

    private AppVersionChange handleAppEventPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.APP_EVENT.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.APP_EVENT);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getAppEventChanges())) {
                this.publishAppEventPatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getAppEventChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }

    private AppVersionChange handleSdkSettingPublishPatch(AppVersion appVersion, PublishContent publishContent, String newVersion) {
        AppVersionChange newVersionChange = new AppVersionChange().setResourceType(ResourceType.SDK_SETTING.code());
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appVersion.getId(), ResourceType.SDK_SETTING);
        if (versionChangeOptl.isPresent()) {
            newVersionChange.setOriginResourceVersion(versionChangeOptl.get().getResourceVersion());
            if (CollectionUtils.isNotEmpty(publishContent.getSdkSettingChanges())) {
                this.publishSdkSettingPatch(newVersion, versionChangeOptl.get().getResourceVersion(), publishContent);
                newVersionChange.setResourceVersion(newVersion);
                newVersionChange.setChangeFlag(ChangeFlag.CHANGED.code());
                newVersionChange.setChangeContent(JSON.toJSONString(publishContent.getSdkSettingChanges()));
            } else {
                newVersionChange.setResourceVersion(versionChangeOptl.get().getResourceVersion());
                newVersionChange.setChangeFlag(ChangeFlag.NOCHANGE.code());
            }
        }
        return newVersionChange;
    }
}

