/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.ApiVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionApi;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(ApiVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApiVersionDiffQuery apiVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionApi> versionItems = this.apiVersionDiffQuery.getVersionApis(appId, appVersionId);
        versionContent.setApis(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setApisDiff(VersionDiffExecutor.diff(versionContent.getApis(), this.apiVersionDiffQuery.getUnPublishedApis(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getApisDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap apisOfDiff = Maps.newHashMap();
                versionContent.getApis().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        apisOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setApisOfDiff(apisOfDiff);
                versionContent.setApis(null);
            }
        }
        this.publishCommonService.buildApiChangeOpInfos(versionContent.getApisDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChg, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg, String retDataType) {
        String rightVersion;
        HashMap<String, VersionApi> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.apiVersionDiffQuery.getVersionApis(appId, leftAppVersionId);
        versionContent.setApis(leftVersionItems);
        String string = rightVersion = null == rightVersionChg ? null : rightVersionChg.getResourceVersion();
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setApisDiff(VersionDiffExecutor.diff(versionContent.getApis(), this.apiVersionDiffQuery.getPublishedVersionApis(appId, rightVersion)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getApisDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap apisOfDiff = Maps.newHashMap();
                versionContent.getApis().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        apisOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setApisOfDiff(apisOfDiff);
                versionContent.setApis(null);
            }
        }
        this.publishCommonService.buildApiChangeOpInfos(versionContent.getApisDiff(), appId, rightVersion);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionApi> leftVersionBos = null == leftAppVersionId ? Maps.newHashMap() : this.apiVersionDiffQuery.getVersionApis(appId, leftAppVersionId);
        return VersionDiffExecutor.diff(leftVersionBos, this.apiVersionDiffQuery.getVersionApis(appId, rightAppVersionId));
    }
}

