/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.AppEventVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionAppEvent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppEventVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(AppEventVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private AppEventVersionDiffQuery appEventVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionAppEvent> versionItems = this.appEventVersionDiffQuery.getVersionAppEvents(appId, appVersionId);
        versionContent.setAppEvents(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setAppEventsDiff(VersionDiffExecutor.diff(versionContent.getAppEvents(), this.appEventVersionDiffQuery.getUnPublishedAppEvents(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getAppEventsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap appEventsOfDiff = Maps.newHashMap();
                versionContent.getAppEvents().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        appEventsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setAppEventsOfDiff(appEventsOfDiff);
                versionContent.setAppEvents(null);
            }
        }
        this.publishCommonService.buildAppEventChangeOpInfos(versionContent.getAppEventsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChg, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg, String retDataType) {
        String rightVersion;
        HashMap<String, VersionAppEvent> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.appEventVersionDiffQuery.getVersionAppEvents(appId, leftAppVersionId);
        versionContent.setAppEvents(leftVersionItems);
        String string = rightVersion = null == rightVersionChg ? null : rightVersionChg.getResourceVersion();
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setAppEventsDiff(VersionDiffExecutor.diff(versionContent.getAppEvents(), this.appEventVersionDiffQuery.getPublishedVersionAppEvents(appId, rightVersion)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getAppEventsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap appEventsOfDiff = Maps.newHashMap();
                versionContent.getAppEvents().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        appEventsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setAppEventsOfDiff(appEventsOfDiff);
                versionContent.setAppEvents(null);
            }
        }
        this.publishCommonService.buildAppEventChangeOpInfos(versionContent.getAppEventsDiff(), appId, rightVersion);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionAppEvent> leftVersionBos = null == leftAppVersionId ? Maps.newHashMap() : this.appEventVersionDiffQuery.getVersionAppEvents(appId, leftAppVersionId);
        return VersionDiffExecutor.diff(leftVersionBos, this.appEventVersionDiffQuery.getVersionAppEvents(appId, rightAppVersionId));
    }
}

