/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FormVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionForm;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(FormVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FormVersionDiffQuery formVersionDiffQuery;
    @Autowired
    private UltFormRepository ultFormRepository;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionForm> versionItems = this.formVersionDiffQuery.getVersionFormsNoSetting(appId, appVersionId);
        versionContent.setForms(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setFormsDiff(this.diffEntry(versionContent.getForms(), this.formVersionDiffQuery.getUnPublishedFormsNoSetting(appId), false));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                versionContent.setFormsOfDiff(this.getMetadataOfDiffMap(versionContent));
                versionContent.setForms(null);
            }
        }
        this.publishCommonService.buildFormChangeOpInfos(versionContent.getFormsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChgs, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs, String retDataType) {
        HashMap<String, VersionForm> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.formVersionDiffQuery.getVersionFormsNoSetting(appId, leftAppVersionId);
        versionContent.setForms(leftVersionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setFormsDiff(this.diffEntry(versionContent.getForms(), this.formVersionDiffQuery.getVersionFormsNoSetting(appId, rightVersionChgs), false));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                versionContent.setFormsOfDiff(this.getMetadataOfDiffMap(versionContent));
                versionContent.setForms(null);
            }
        }
        this.publishCommonService.buildFormChangeOpInfos(appId, versionContent.getFormsDiff(), rightVersionChgs);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        return this.getDiff(appId, leftAppVersionId, rightAppVersionId, true);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId, boolean parseSetting) {
        HashMap<String, VersionForm> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.formVersionDiffQuery.getVersionFormsNoSetting(appId, leftAppVersionId);
        HashMap<String, VersionForm> rightVersionItems = this.formVersionDiffQuery.getVersionFormsNoSetting(appId, rightAppVersionId);
        return this.diffEntry(leftVersionItems, rightVersionItems, parseSetting);
    }

    private List<ChangedItem> diffEntry(Map<String, VersionForm> leftVersionItems, Map<String, VersionForm> rightVersionItems, boolean parseSetting) {
        HashSet result = Sets.newHashSet();
        result.addAll(leftVersionItems.keySet());
        result.addAll(rightVersionItems.keySet());
        return result.stream().map(code -> {
            HashMap leftVersionItemMap = Maps.newHashMap();
            if (leftVersionItems.containsKey(code)) {
                leftVersionItemMap.put(code, leftVersionItems.get(code));
            }
            HashMap rightVersionItemMap = Maps.newHashMap();
            if (rightVersionItems.containsKey(code)) {
                rightVersionItemMap.put(code, rightVersionItems.get(code));
            }
            return this.diff(leftVersionItemMap, rightVersionItemMap, parseSetting);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ChangedItem> diff(Map<String, VersionForm> lastVersionForms, Map<String, VersionForm> newestForms, boolean parseSetting) {
        List<Object> changedItems;
        if (lastVersionForms.isEmpty() && !newestForms.isEmpty()) {
            changedItems = newestForms.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.ADD.code()).setPath("/" + (String)entry.getKey()).setValue((Object)((VersionForm)entry.getValue()).setSetting(null))).collect(Collectors.toList());
        } else if (!lastVersionForms.isEmpty() && newestForms.isEmpty()) {
            changedItems = lastVersionForms.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.REMOVE.code()).setPath("/" + (String)entry.getKey()).setValue((Object)((VersionForm)entry.getValue()).setSetting(null))).collect(Collectors.toList());
        } else {
            this.fillSetting(lastVersionForms, newestForms, parseSetting);
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            try {
                String formIdStr = (String)lastVersionForms.keySet().stream().findAny().get();
                log.debug("start readTree left, form {}", (Object)formIdStr);
                JsonNode left = objectMapper.readTree(JSON.toJSONString(lastVersionForms, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                log.debug("finish readTree left, form {}", (Object)formIdStr);
                log.debug("start readTree right, form {}", (Object)formIdStr);
                JsonNode right = objectMapper.readTree(JSON.toJSONString(newestForms, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                log.debug("finish readTree right, form {}", (Object)formIdStr);
                log.debug("start diff, form {}", (Object)formIdStr);
                JsonNode patch = JsonDiff.asJson((JsonNode)left, (JsonNode)right, (EnumSet)flags);
                log.debug("finish diff, form {}", (Object)formIdStr);
                log.debug("start changedItems, form {}", (Object)formIdStr);
                Iterable itor = () -> ((JsonNode)patch).iterator();
                changedItems = StreamSupport.stream(itor.spliterator(), false).map(ele -> (ChangedItem)JSON.parseObject((String)ele.toString(), ChangedItem.class)).collect(Collectors.toList());
                lastVersionForms.forEach((key, value) -> value.setSetting(null));
                newestForms.forEach((key, value) -> value.setSetting(null));
                log.debug("finish changedItems, form {}", (Object)formIdStr);
            }
            catch (JsonProcessingException e) {
                log.error("Json \u5904\u7406\u5931\u8d25", (Throwable)e);
                return Lists.newArrayList();
            }
        }
        return changedItems;
    }

    private void parseSetting(Map<String, VersionForm> lastVersionForms, Map<String, VersionForm> newestForms) {
        Optional<VersionForm> lOptl = lastVersionForms.values().stream().findAny();
        Optional<VersionForm> nOptl = newestForms.values().stream().findAny();
        if (lOptl.isPresent() && null != lOptl.get().getSetting()) {
            lOptl.get().setSetting(JSON.parse((String)((String)lOptl.get().getSetting())));
        }
        if (nOptl.isPresent() && null != nOptl.get().getSetting()) {
            nOptl.get().setSetting(JSON.parse((String)((String)nOptl.get().getSetting())));
        }
    }

    private void fillSetting(Map<String, VersionForm> lastVersionForms, Map<String, VersionForm> newestForms, boolean parseSetting) {
        VersionForm lastVersionForm = lastVersionForms.values().stream().findAny().get();
        VersionForm newestForm = newestForms.values().stream().findAny().get();
        if (null == lastVersionForm.getUpdateTime() || null == newestForm.getUpdateTime() || !lastVersionForm.getUpdateTime().equals(newestForm.getUpdateTime())) {
            UltForm lastVersionFormSetting = this.ultFormRepository.getFormWithValidate(lastVersionForm.getOriginId());
            UltForm newestFormSetting = this.ultFormRepository.getFormWithValidate(newestForm.getOriginId());
            if (parseSetting) {
                lastVersionForm.setSetting(JSON.parse((String)lastVersionFormSetting.getSetting()));
                newestForm.setSetting(JSON.parse((String)newestFormSetting.getSetting()));
            } else {
                lastVersionForm.setSetting(lastVersionFormSetting.getSetting());
                newestForm.setSetting(newestFormSetting.getSetting());
            }
        }
        this.clearVersionCommonInfo(lastVersionForm);
        this.clearVersionCommonInfo(newestForm);
        log.debug("finish get setting, page {} setting", (Object)lastVersionForm.getId());
    }

    private void clearVersionCommonInfo(VersionForm versionForm) {
        versionForm.setOriginId(null);
        versionForm.setUpdateTime(null);
    }

    private HashMap<String, VersionForm> getMetadataOfDiffMap(VersionContent versionContent) {
        List ids = versionContent.getFormsDiff().stream().map(item -> {
            String[] strs = item.getPath().substring(1).split("/");
            return strs.length > 0 ? Long.valueOf(strs[0]) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (HashMap)versionContent.getForms().values().stream().filter(v -> ids.contains(v.getId())).collect(Collectors.toMap(v -> v.getId().toString(), Function.identity()));
    }
}

