/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.PageSettingVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPageSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageSettingVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(PageSettingVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private PageSettingVersionDiffQuery pageSettingVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionPageSetting> versionItems = this.pageSettingVersionDiffQuery.getVersionPageSettings(appId, appVersionId);
        versionContent.setPageSettings(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setPageSettingsDiff(VersionDiffExecutor.diffEntry(versionContent.getPageSettings(), this.pageSettingVersionDiffQuery.getUnPublishedPageSettings(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getPageSettingsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap ultPageSettingsOfDiff = Maps.newHashMap();
                versionContent.getPageSettings().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        ultPageSettingsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setPageSettingsOfDiff(ultPageSettingsOfDiff);
                versionContent.setPageSettings(null);
            }
        }
        this.publishCommonService.buildPageSettingChangeOpInfos(versionContent.getPageSettingsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChgs, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs, String retDataType) {
        HashMap<String, VersionPageSetting> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.pageSettingVersionDiffQuery.getVersionPageSettings(appId, leftAppVersionId);
        versionContent.setPageSettings(leftVersionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setPageSettingsDiff(VersionDiffExecutor.diffEntry(versionContent.getPageSettings(), this.pageSettingVersionDiffQuery.getPublishedVersionPageSettings(appId, rightVersionChgs)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                versionContent.setPageSettingsOfDiff(this.getMetadataOfDiffMap(versionContent));
                versionContent.setPageSettings(null);
            }
        }
        this.publishCommonService.buildPageSettingChangeOpInfos(appId, versionContent.getPageSettingsDiff(), rightVersionChgs);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionPageSetting> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.pageSettingVersionDiffQuery.getVersionPageSettings(appId, leftAppVersionId);
        return VersionDiffExecutor.diffEntry(leftVersionItems, this.pageSettingVersionDiffQuery.getVersionPageSettings(appId, rightAppVersionId));
    }

    private HashMap<String, VersionPageSetting> getMetadataOfDiffMap(VersionContent versionContent) {
        List ids = versionContent.getFlowSettingsDiff().stream().map(item -> {
            String[] strs = item.getPath().substring(1).split("/");
            return strs.length > 0 ? Long.valueOf(strs[0]) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (HashMap)versionContent.getPageSettings().values().stream().filter(v -> ids.contains(v.getId())).collect(Collectors.toMap(v -> v.getId().toString(), Function.identity()));
    }
}

