/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.PageVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPage;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPageBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.PageBoSettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(PageVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private PageVersionDiffQuery pageVersionDiffQuery;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionPage> versionItems = this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, appVersionId);
        versionContent.setPages(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            log.debug("start all page diff, appId {} versionId {}", (Object)appId, (Object)appVersionId);
            Map<String, VersionPage> unItems = this.pageVersionDiffQuery.getUnPublishedPagesNoSetting(appId);
            versionContent.setPagesDiff(this.diffEntry(versionContent.getPages(), unItems, false));
            log.debug("finish all page diff, appId {} versionId {}", (Object)appId, (Object)appVersionId);
            if (RetDataType.DIFF.code().equals(retDataType)) {
                versionContent.setPagesOfDiff(this.getMetadataOfDiffMap(versionContent));
                versionContent.setPages(null);
            }
        }
        log.debug("start buildPageChangeOpInfos, appId {} versionId {}", (Object)appId, (Object)appVersionId);
        this.publishCommonService.buildPageChangeOpInfos(versionContent.getPagesDiff());
        log.debug("finish buildPageChangeOpInfos, appId {} versionId {}", (Object)appId, (Object)appVersionId);
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChgs, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, List<AppVersionChange> rightVersionChgs, String retDataType) {
        HashMap<String, VersionPage> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, leftAppVersionId);
        versionContent.setPages(leftVersionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setPagesDiff(this.diffEntry(versionContent.getPages(), this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, rightVersionChgs), false));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getPagesDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap pagesOfDiff = Maps.newHashMap();
                versionContent.getPages().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        pagesOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setPagesOfDiff(pagesOfDiff);
                versionContent.setPages(null);
            }
        }
        this.publishCommonService.buildPageChangeOpInfos(appId, versionContent.getPagesDiff(), rightVersionChgs);
    }

    public List<ChangedItem> diff(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages) {
        return this.diff(lastVersionPages, newestPages, true);
    }

    public List<ChangedItem> diff(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages, boolean parseSetting) {
        List<Object> changedItems;
        if (lastVersionPages.isEmpty() && !newestPages.isEmpty()) {
            changedItems = newestPages.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.ADD.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else if (!lastVersionPages.isEmpty() && newestPages.isEmpty()) {
            changedItems = lastVersionPages.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.REMOVE.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else {
            this.fillPageBoSetting(lastVersionPages, newestPages, parseSetting);
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            try {
                String pageIdStr = (String)lastVersionPages.keySet().stream().findAny().get();
                log.debug("start readTree left, page {}", (Object)pageIdStr);
                JsonNode left = objectMapper.readTree(JSON.toJSONString(lastVersionPages, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                log.debug("finish readTree left, page {}", (Object)pageIdStr);
                log.debug("start readTree right, page {}", (Object)pageIdStr);
                JsonNode right = objectMapper.readTree(JSON.toJSONString(newestPages, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                log.debug("finish readTree right, page {}", (Object)pageIdStr);
                log.debug("start diff, page {}", (Object)pageIdStr);
                JsonNode patch = JsonDiff.asJson((JsonNode)left, (JsonNode)right, (EnumSet)flags);
                log.debug("finish diff, page {}", (Object)pageIdStr);
                log.debug("start changedItems, page {}", (Object)pageIdStr);
                Iterable itor = () -> ((JsonNode)patch).iterator();
                changedItems = StreamSupport.stream(itor.spliterator(), false).map(ele -> (ChangedItem)JSON.parseObject((String)ele.toString(), ChangedItem.class)).collect(Collectors.toList());
                lastVersionPages.values().forEach(o -> o.getPageBoSettings().forEach((key, value) -> value.setSetting(null)));
                newestPages.values().forEach(o -> o.getPageBoSettings().forEach((key, value) -> value.setSetting(null)));
                log.debug("finish changedItems, page {}", (Object)pageIdStr);
            }
            catch (JsonProcessingException e) {
                log.error("Json \u5904\u7406\u5931\u8d25", (Throwable)e);
                return Lists.newArrayList();
            }
        }
        return changedItems;
    }

    private void fillPageBoSetting(Map<String, VersionPage> lastVersionPages, Map<String, VersionPage> newestPages, boolean parseSetting) {
        VersionPage lastVersionPage = lastVersionPages.values().stream().findAny().get();
        VersionPage newestPage = newestPages.values().stream().findAny().get();
        List<Object> settingIds = Lists.newArrayList();
        settingIds.addAll(lastVersionPage.getPageBoSettings().values().stream().map(VersionPageBo::getId).collect(Collectors.toList()));
        settingIds.addAll(newestPage.getPageBoSettings().values().stream().map(VersionPageBo::getId).collect(Collectors.toList()));
        settingIds = settingIds.stream().distinct().collect(Collectors.toList());
        log.debug("start get setting, page {} setting count old:{} new:{}", new Object[]{lastVersionPage.getId(), lastVersionPage.getPageBoSettings().size(), newestPage.getPageBoSettings().size()});
        ArrayList originIds = Lists.newArrayList();
        settingIds.forEach(settingId -> {
            Optional<VersionPageBo> lOptl = lastVersionPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            Optional<VersionPageBo> nOptl = newestPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            if (lOptl.isPresent() && !nOptl.isPresent()) {
                originIds.add(lOptl.get().getOriginId());
            } else if (!lOptl.isPresent() && nOptl.isPresent()) {
                originIds.add(nOptl.get().getOriginId());
            } else if (lOptl.isPresent() && nOptl.isPresent() && (null == lOptl.get().getUpdateTime() || null == nOptl.get().getUpdateTime() || !lOptl.get().getUpdateTime().equals(nOptl.get().getUpdateTime()))) {
                originIds.add(lOptl.get().getOriginId());
                originIds.add(nOptl.get().getOriginId());
            }
        });
        Map<Long, String> originIdSettingMap = this.getSettingMap(originIds);
        settingIds.forEach(settingId -> {
            Optional<VersionPageBo> lOptl = lastVersionPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            Optional<VersionPageBo> nOptl = newestPage.getPageBoSettings().values().stream().filter(p -> p.getId().equals(settingId)).findAny();
            if (lOptl.isPresent() && !nOptl.isPresent()) {
                lOptl.get().setSetting(originIdSettingMap.get(lOptl.get().getOriginId()));
            } else if (!lOptl.isPresent() && nOptl.isPresent()) {
                nOptl.get().setSetting(originIdSettingMap.get(nOptl.get().getOriginId()));
            } else if (lOptl.isPresent() && nOptl.isPresent() && (null == lOptl.get().getUpdateTime() || null == nOptl.get().getUpdateTime() || !lOptl.get().getUpdateTime().equals(nOptl.get().getUpdateTime()))) {
                lOptl.get().setSetting(originIdSettingMap.get(lOptl.get().getOriginId()));
                nOptl.get().setSetting(originIdSettingMap.get(nOptl.get().getOriginId()));
            }
            lOptl.ifPresent(this::clearVersionCommonInfo);
            nOptl.ifPresent(this::clearVersionCommonInfo);
        });
        log.debug("finish get setting, page {} setting count old:{} new:{}", new Object[]{lastVersionPage.getId(), lastVersionPage.getPageBoSettings().size(), newestPage.getPageBoSettings().size()});
    }

    private void clearVersionCommonInfo(VersionPageBo versionPageBo) {
        versionPageBo.setOriginId(null);
        versionPageBo.setUpdateTime(null);
    }

    private String getSetting(Long originId) {
        PageBoSetting pageBoSetting = (PageBoSetting)this.pageBoSettingMapper.selectOne((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{PageBoSetting::getSetting}).eq(PageBoSetting::getId, (Object)originId));
        return pageBoSetting.getSetting();
    }

    private Map<Long, String> getSettingMap(List<Long> originIds) {
        return CollectionUtils.isEmpty(originIds) ? Maps.newHashMap() : this.pageBoSettingMapper.selectList((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{PageBoSetting::getId, PageBoSetting::getSetting}).in(PageBoSetting::getId, originIds)).stream().collect(Collectors.toMap(PageBoSetting::getId, PageBoSetting::getSetting));
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        return this.getDiff(appId, leftAppVersionId, rightAppVersionId, true);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId, boolean parseSetting) {
        HashMap<String, VersionPage> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, leftAppVersionId);
        HashMap<String, VersionPage> rightVersionItems = this.pageVersionDiffQuery.getVersionPagesNoSetting(appId, rightAppVersionId);
        return this.diffEntry(leftVersionItems, rightVersionItems, parseSetting);
    }

    private Object parsePageBoSetting(String pageBoSetting, boolean parseSetting) {
        return parseSetting ? JSON.parse((String)pageBoSetting) : pageBoSetting;
    }

    private List<ChangedItem> diffEntry(Map<String, VersionPage> leftVersionItems, Map<String, VersionPage> rightVersionItems) {
        return this.diffEntry(leftVersionItems, rightVersionItems, true);
    }

    private List<ChangedItem> diffEntry(Map<String, VersionPage> leftVersionItems, Map<String, VersionPage> rightVersionItems, boolean parseSetting) {
        HashSet result = Sets.newHashSet();
        result.addAll(leftVersionItems.keySet());
        result.addAll(rightVersionItems.keySet());
        return result.stream().map(code -> {
            HashMap leftVersionItemMap = Maps.newHashMap();
            if (leftVersionItems.containsKey(code)) {
                leftVersionItemMap.put(code, leftVersionItems.get(code));
            }
            HashMap rightVersionItemMap = Maps.newHashMap();
            if (rightVersionItems.containsKey(code)) {
                rightVersionItemMap.put(code, rightVersionItems.get(code));
            }
            return this.diff(leftVersionItemMap, rightVersionItemMap, parseSetting);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private HashMap<String, VersionPage> getMetadataOfDiffMap(VersionContent versionContent) {
        List ids = versionContent.getPagesDiff().stream().map(item -> {
            String[] strs = item.getPath().substring(1).split("/");
            return strs.length > 0 ? Long.valueOf(strs[0]) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (HashMap)versionContent.getPages().values().stream().filter(v -> ids.contains(v.getId())).collect(Collectors.toMap(v -> v.getId().toString(), Function.identity()));
    }
}

