/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.RuleVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(RuleVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private RuleVersionDiffQuery ruleVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionRule> versionSueRules = this.ruleVersionDiffQuery.getVersionRules(appId, appVersionId);
        versionContent.setRules(versionSueRules);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setRulesDiff(VersionDiffExecutor.diff(versionContent.getRules(), this.ruleVersionDiffQuery.getUnPublishedSueRules(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getRulesDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap sueRulesOfDiff = Maps.newHashMap();
                versionContent.getRules().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        sueRulesOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setRulesOfDiff(sueRulesOfDiff);
                versionContent.setRules(null);
            }
        }
        this.publishCommonService.buildRuleChangeOpInfos(versionContent.getRulesDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChange) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChange, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChange, String retDataType) {
        String rightVersion = null == rightVersionChange ? null : rightVersionChange.getResourceVersion();
        HashMap<String, VersionRule> leftVersionRules = null == leftAppVersionId ? Maps.newHashMap() : this.ruleVersionDiffQuery.getVersionRules(appId, leftAppVersionId);
        versionContent.setRules(leftVersionRules);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setRulesDiff(VersionDiffExecutor.diff(versionContent.getRules(), this.ruleVersionDiffQuery.getPublishedVersionRules(appId, rightVersion)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getRulesDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap sueRulesOfDiff = Maps.newHashMap();
                versionContent.getRules().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        sueRulesOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setRulesOfDiff(sueRulesOfDiff);
                versionContent.setRules(null);
            }
        }
        this.publishCommonService.buildRuleChangeOpInfos(versionContent.getRulesDiff(), appId, rightVersion);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionRule> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.ruleVersionDiffQuery.getVersionRules(appId, leftAppVersionId);
        return VersionDiffExecutor.diff(leftVersionItems, this.ruleVersionDiffQuery.getVersionRules(appId, rightAppVersionId));
    }
}

