/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.TagVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionTag;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagVersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(TagVersionDiffExecutor.class);
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private TagVersionDiffQuery tagVersionDiffQuery;

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId) {
        this.fillDiff(versionContent, appId, appVersionId, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long appVersionId, String retDataType) {
        HashMap<String, VersionTag> versionItems = this.tagVersionDiffQuery.getVersionTags(appId, appVersionId);
        versionContent.setTags(versionItems);
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setTagsDiff(VersionDiffExecutor.diff(versionContent.getTags(), this.tagVersionDiffQuery.getUnPublishedTags(appId)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getTagsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap tagsOfDiff = Maps.newHashMap();
                versionContent.getTags().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        tagsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setTagsOfDiff(tagsOfDiff);
                versionContent.setTags(null);
            }
        }
        this.publishCommonService.buildTagChangeOpInfos(versionContent.getTagsDiff());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg) {
        this.fillDiff(versionContent, appId, leftAppVersionId, rightVersionChg, RetDataType.ALL.code());
    }

    public void fillDiff(VersionContent versionContent, Long appId, Long leftAppVersionId, AppVersionChange rightVersionChg, String retDataType) {
        String rightVersion;
        HashMap<String, VersionTag> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.tagVersionDiffQuery.getVersionTags(appId, leftAppVersionId);
        versionContent.setTags(leftVersionItems);
        String string = rightVersion = null == rightVersionChg ? null : rightVersionChg.getResourceVersion();
        if (!RetDataType.META.code().equals(retDataType)) {
            versionContent.setTagsDiff(VersionDiffExecutor.diff(versionContent.getTags(), this.tagVersionDiffQuery.getPublishedVersionTags(appId, rightVersion)));
            if (RetDataType.DIFF.code().equals(retDataType)) {
                List ids = versionContent.getTagsDiff().stream().map(item -> {
                    String[] strs = item.getPath().substring(1).split("/");
                    return strs.length > 0 ? Long.valueOf(strs[0]) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                HashMap tagsOfDiff = Maps.newHashMap();
                versionContent.getTags().values().forEach(v -> {
                    if (ids.contains(v.getId())) {
                        tagsOfDiff.put(v.getId().toString(), v);
                    }
                });
                versionContent.setTagsOfDiff(tagsOfDiff);
                versionContent.setTags(null);
            }
        }
        this.publishCommonService.buildTagChangeOpInfos(versionContent.getTagsDiff(), appId, rightVersion);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        HashMap<String, VersionTag> leftVersionItems = null == leftAppVersionId ? Maps.newHashMap() : this.tagVersionDiffQuery.getVersionTags(appId, leftAppVersionId);
        return VersionDiffExecutor.diff(leftVersionItems, this.tagVersionDiffQuery.getVersionTags(appId, rightAppVersionId));
    }
}

