/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.version.diff.ApiVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.AppEventVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.BoVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.DictVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FlowActionVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FlowSettingVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FormVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.PageSettingVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.PageVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.RuleVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.SdkSettingVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.TagVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.enums.RetDataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionDiffAggregator {
    private static final Logger log = LoggerFactory.getLogger(VersionDiffAggregator.class);
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private BoVersionDiffExecutor boVersionDiffExecutor;
    @Autowired
    private DictVersionDiffExecutor dictVersionDiffExecutor;
    @Autowired
    private PageVersionDiffExecutor pageVersionDiffExecutor;
    @Autowired
    private FormVersionDiffExecutor formVersionDiffExecutor;
    @Autowired
    private FlowActionVersionDiffExecutor flowActionVersionDiffExecutor;
    @Autowired
    private FlowSettingVersionDiffExecutor flowSettingVersionDiffExecutor;
    @Autowired
    private ApiVersionDiffExecutor apiVersionDiffExecutor;
    @Autowired
    private RuleVersionDiffExecutor ruleVersionDiffExecutor;
    @Autowired
    private TagVersionDiffExecutor tagVersionDiffExecutor;
    @Autowired
    private AppEventVersionDiffExecutor appEventVersionDiffExecutor;
    @Autowired
    private SdkSettingVersionDiffExecutor sdkSettingVersionDiffExecutor;
    @Autowired
    private PageSettingVersionDiffExecutor pageSettingVersionDiffExecutor;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    public VersionContent executeDiff(Long appId, AppVersion appVersion) {
        Long appVersionId = null == appVersion ? null : appVersion.getId();
        VersionContent versionContent = new VersionContent();
        List<Supplier<Boolean>> suppliers = Arrays.asList(() -> {
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        }, () -> {
            this.pageSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId);
            return true;
        });
        this.asyncExec(suppliers);
        return versionContent;
    }

    public VersionContent executeDiff(Long appId, AppVersion appVersion, MetadataType metadataType, String retDataType) {
        Long appVersionId;
        long startTime = System.currentTimeMillis();
        Long l = appVersionId = null == appVersion ? null : appVersion.getId();
        if (RetDataType.META.code().equals(retDataType)) {
            return this.metadataVersionQuery.getVersionMeta(appId, appVersionId, metadataType);
        }
        VersionContent versionContent = new VersionContent();
        if (MetadataType.BO.equals((Object)metadataType)) {
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.DICT.equals((Object)metadataType)) {
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.PAGE.equals((Object)metadataType)) {
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.FORM.equals((Object)metadataType)) {
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.FLOW_ACTION.equals((Object)metadataType)) {
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.FLOW_SETTING.equals((Object)metadataType)) {
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.API.equals((Object)metadataType)) {
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.RULE.equals((Object)metadataType)) {
            this.ruleVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.TAG.equals((Object)metadataType)) {
            this.tagVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.APP_EVENT.equals((Object)metadataType)) {
            this.appEventVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.SDK_SETTING.equals((Object)metadataType)) {
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else if (MetadataType.PAGE_SETTING.equals((Object)metadataType)) {
            this.pageSettingVersionDiffExecutor.fillDiff(versionContent, appId, appVersionId, retDataType);
        } else {
            log.error(String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        log.debug("execution diff time: {}", (Object)((System.currentTimeMillis() - startTime) / 1000L + "s"));
        return versionContent;
    }

    public ServiceResponse executeDiff(Long appId, Long leftVersionId, Long rightVersionId) {
        if (leftVersionId != null && leftVersionId.equals(rightVersionId)) {
            return ServiceResponse.success((String)"", (Object)new VersionContent());
        }
        AppVersion leftAppVersion = this.appVersionQuery.getAppVersion(appId, leftVersionId, true).orElse(null);
        AppVersion rightAppVersion = this.appVersionQuery.getAppVersionWithValidate(appId, rightVersionId, false);
        List<AppVersionChange> rightVersionChanges = this.appVersionQuery.getAppVersionChanges(rightVersionId);
        if (rightVersionChanges.isEmpty()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u88ab\u6bd4\u8f83\u7684\u7248\u672c\u5dee\u5f02\u4fe1\u606f");
        }
        VersionContent versionContent = new VersionContent();
        List<Supplier<Boolean>> suppliers = Arrays.asList(() -> {
            Optional<AppVersionChange> rightBoChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.BO.code().equals(vc.getResourceType())).findAny();
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightBoChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightDictChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.DICT.code().equals(vc.getResourceType())).findAny();
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightDictChangeOptl.orElse(null));
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.PAGE.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.FORM.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            Optional<AppVersionChange> rightActionChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.FLOW_ACTION.code().equals(vc.getResourceType())).findAny();
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightActionChangeOptl.orElse(null));
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.FLOW_SETTING.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        }, () -> {
            Optional<AppVersionChange> rightApiChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.API.code().equals(vc.getResourceType())).findAny();
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightApiChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.RULE.code().equals(vc.getResourceType())).findAny();
            this.ruleVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.TAG.code().equals(vc.getResourceType())).findAny();
            this.tagVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.APP_EVENT.code().equals(vc.getResourceType())).findAny();
            this.appEventVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.SDK_SETTING.code().equals(vc.getResourceType())).findAny();
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, (AppVersionChange)rightChangeOptl.orElse(null));
            return true;
        }, () -> {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.PAGE_SETTING.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.pageSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs);
            return true;
        });
        this.asyncExec(suppliers);
        log.debug("{} {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId, (Object)rightAppVersion.getVersion());
        versionContent.setAppVersionExist(leftAppVersion != null);
        versionContent.setRemark(rightAppVersion.getRemark());
        versionContent.setAppVersions(this.metadataVersionQuery.getAppVersions(appId, leftVersionId, rightVersionId));
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    public ServiceResponse executeDiff(Long appId, Long leftVersionId, Long rightVersionId, MetadataType metadataType, String retDataType) {
        if (leftVersionId != null && leftVersionId.equals(rightVersionId)) {
            return ServiceResponse.success((String)"", (Object)new VersionContent());
        }
        AppVersion leftAppVersion = this.appVersionQuery.getAppVersion(appId, leftVersionId, true).orElse(null);
        AppVersion rightAppVersion = this.appVersionQuery.getAppVersionWithValidate(appId, rightVersionId, false);
        List<AppVersionChange> rightVersionChanges = this.appVersionQuery.getAppVersionChanges(rightVersionId);
        if (rightVersionChanges.isEmpty()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u88ab\u6bd4\u8f83\u7684\u7248\u672c\u5dee\u5f02\u4fe1\u606f");
        }
        VersionContent versionContent = new VersionContent();
        if (MetadataType.BO.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightBoChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.BO.code().equals(vc.getResourceType())).findAny();
            this.boVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightBoChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.DICT.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightDictChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.DICT.code().equals(vc.getResourceType())).findAny();
            this.dictVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightDictChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.PAGE.equals((Object)metadataType)) {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.PAGE.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.pageVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs, retDataType);
        } else if (MetadataType.FORM.equals((Object)metadataType)) {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.FORM.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.formVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs, retDataType);
        } else if (MetadataType.FLOW_ACTION.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightActionChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.FLOW_ACTION.code().equals(vc.getResourceType())).findAny();
            this.flowActionVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightActionChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.FLOW_SETTING.equals((Object)metadataType)) {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.FLOW_SETTING.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.flowSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs, retDataType);
        } else if (MetadataType.API.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightApiChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.API.code().equals(vc.getResourceType())).findAny();
            this.apiVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightApiChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.RULE.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.RULE.code().equals(vc.getResourceType())).findAny();
            this.ruleVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.TAG.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.TAG.code().equals(vc.getResourceType())).findAny();
            this.tagVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.APP_EVENT.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.APP_EVENT.code().equals(vc.getResourceType())).findAny();
            this.appEventVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.SDK_SETTING.equals((Object)metadataType)) {
            Optional<AppVersionChange> rightChangeOptl = rightVersionChanges.stream().filter(vc -> MetadataType.SDK_SETTING.code().equals(vc.getResourceType())).findAny();
            this.sdkSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightChangeOptl.orElse(null), retDataType);
        } else if (MetadataType.PAGE_SETTING.equals((Object)metadataType)) {
            List<AppVersionChange> rightVersionChgs = rightVersionChanges.stream().filter(vc -> MetadataType.PAGE_SETTING.code().equals(vc.getResourceType())).collect(Collectors.toList());
            this.pageSettingVersionDiffExecutor.fillDiff(versionContent, appId, leftVersionId, rightVersionChgs, retDataType);
        } else {
            log.error(String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        log.debug("{} {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId, (Object)rightAppVersion.getVersion());
        versionContent.setAppVersionExist(leftAppVersion != null);
        versionContent.setRemark(rightAppVersion.getRemark());
        versionContent.setAppVersions(this.metadataVersionQuery.getAppVersions(appId, leftVersionId, rightVersionId));
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    public List<ChangedItem> diffBos(Map<String, VersionBo> lastVersionBos, Map<String, VersionBo> newestBos) {
        return VersionDiffExecutor.diff(lastVersionBos, newestBos);
    }

    public List<ChangedItem> getDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId, MetadataType metadataType) {
        List<Object> changedItems = Lists.newArrayList();
        if (MetadataType.BO.equals((Object)metadataType)) {
            changedItems = this.boVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.DICT.equals((Object)metadataType)) {
            changedItems = this.dictVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.PAGE.equals((Object)metadataType)) {
            changedItems = this.pageVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.FORM.equals((Object)metadataType)) {
            changedItems = this.formVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.FLOW_ACTION.equals((Object)metadataType)) {
            changedItems = this.flowActionVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.FLOW_SETTING.equals((Object)metadataType)) {
            changedItems = this.flowSettingVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.API.equals((Object)metadataType)) {
            changedItems = this.apiVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.RULE.equals((Object)metadataType)) {
            changedItems = this.ruleVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.TAG.equals((Object)metadataType)) {
            changedItems = this.tagVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.APP_EVENT.equals((Object)metadataType)) {
            changedItems = this.appEventVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.SDK_SETTING.equals((Object)metadataType)) {
            changedItems = this.sdkSettingVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else if (MetadataType.PAGE_SETTING.equals((Object)metadataType)) {
            changedItems = this.pageSettingVersionDiffExecutor.getDiff(appId, leftAppVersionId, rightAppVersionId);
        } else {
            log.error(String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        return changedItems;
    }

    public List<ChangedItem> getBosSysExclusiveDiff(Long appId, Long leftAppVersionId, Long rightAppVersionId) {
        return this.boVersionDiffExecutor.getDiffSysExclusive(appId, leftAppVersionId, rightAppVersionId);
    }

    private void asyncExec(List<Supplier<Boolean>> suppliers) {
        ExecutorService executor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(suppliers.size()));
        List<CompletableFuture> diffTasks = suppliers.stream().map(supplier -> CompletableFuture.supplyAsync(supplier, executor)).collect(Collectors.toList());
        CompletableFuture<Void> allTasksFuture = CompletableFuture.allOf(diffTasks.toArray(new CompletableFuture[0]));
        try {
            allTasksFuture.join();
        }
        catch (Exception e) {
            log.error("\u5dee\u5f02\u5bf9\u6bd4\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

