/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDiffExecutor {
    private static final Logger log = LoggerFactory.getLogger(VersionDiffExecutor.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> List<ChangedItem> diff(Map<String, T> lastVersionItems, Map<String, T> newestItems) {
        List<Object> changedItems;
        if (lastVersionItems.isEmpty() && !newestItems.isEmpty()) {
            changedItems = newestItems.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.ADD.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else if (!lastVersionItems.isEmpty() && newestItems.isEmpty()) {
            changedItems = lastVersionItems.entrySet().stream().map(entry -> new ChangedItem().setOp(DiffType.REMOVE.code()).setPath("/" + (String)entry.getKey()).setValue(entry.getValue())).collect(Collectors.toList());
        } else {
            Object flags = DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone();
            try {
                JsonNode left = objectMapper.readTree(JSON.toJSONString(lastVersionItems, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                JsonNode right = objectMapper.readTree(JSON.toJSONString(newestItems, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteNullNumberAsZero}));
                JsonNode patch = JsonDiff.asJson((JsonNode)left, (JsonNode)right, (EnumSet)flags);
                Iterable itor = () -> ((JsonNode)patch).iterator();
                changedItems = StreamSupport.stream(itor.spliterator(), false).map(ele -> (ChangedItem)JSON.parseObject((String)ele.toString(), ChangedItem.class)).collect(Collectors.toList());
            }
            catch (JsonProcessingException e) {
                log.error("Json \u5904\u7406\u5931\u8d25", (Throwable)e);
                return Lists.newArrayList();
            }
        }
        return changedItems;
    }

    public static <T> List<ChangedItem> diffEntry(Map<String, T> leftVersionItems, Map<String, T> rightVersionItems) {
        HashSet result = Sets.newHashSet();
        result.addAll(leftVersionItems.keySet());
        result.addAll(rightVersionItems.keySet());
        return result.parallelStream().map(code -> {
            HashMap leftVersionItemMap = Maps.newHashMap();
            if (leftVersionItems.containsKey(code)) {
                leftVersionItemMap.put(code, leftVersionItems.get(code));
            }
            HashMap rightVersionItemMap = Maps.newHashMap();
            if (rightVersionItems.containsKey(code)) {
                rightVersionItemMap.put(code, rightVersionItems.get(code));
            }
            return VersionDiffExecutor.diff(leftVersionItemMap, rightVersionItemMap);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

