/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionAppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionAppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEventSubscribe;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventSubscribeService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppEventVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(AppEventVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private IAppEventSubscribeService appEventSubscribeService;

    public HashMap<String, VersionAppEvent> getVersionAppEvents(Long appId, Long appVersionId) {
        AppVersionChange appEventVersionChange;
        String version = null == appVersionId ? this.getLatestAppEventVersion(appId) : ((appEventVersionChange = (AppVersionChange)this.appVersionQuery.getAppVersionChange(appVersionId, MetadataType.APP_EVENT).orElse(null)) == null ? null : appEventVersionChange.getResourceVersion());
        return null == version ? Maps.newHashMap() : (HashMap)this.getPublishedVersionAppEvents(appId, version);
    }

    public String getLatestAppEventVersion(Long appId) {
        List uAppEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.isNull(AppEvent::getPublishFlag)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code());
            });
        })).orderByDesc(AppEvent::getCreateTime));
        return this.getLatestAppEventVersion(appId, uAppEvents);
    }

    public String getLatestAppEventVersion(Long appId, List<AppEvent> uAppEvents) {
        if (uAppEvents.isEmpty()) {
            List pAppEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(AppEvent::getId));
            return pAppEvents.isEmpty() ? null : ((AppEvent)pAppEvents.get(0)).getVersion();
        }
        return uAppEvents.get(0).getVersion();
    }

    public Map<String, VersionAppEvent> getUnPublishedAppEvents(Long appId) {
        List appEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        return this.buildVersionAppEventMap(appEvents);
    }

    public Map<String, VersionAppEvent> getPublishedVersionAppEvents(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List appEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getVersion, (Object)version));
        return this.buildVersionAppEventMap(appEvents);
    }

    public Map<String, VersionAppEvent> buildVersionAppEventMap(List<AppEvent> appEvents) {
        if (appEvents.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<AppEventSubscribe>> subscribesMap = this.appEventSubscribeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(AppEventSubscribe::getEventId, (Collection)appEvents.stream().map(AppEvent::getId).collect(Collectors.toList()))).eq(AppEventSubscribe::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(AppEventSubscribe::getEventId));
        return appEvents.stream().map(o -> {
            VersionAppEvent versionAppEvent = VersionAppEventStructMapper.MAPPER.toVersionAppEvent((AppEvent)o);
            Optional.ofNullable(subscribesMap.get(o.getId())).ifPresent(s -> versionAppEvent.setSubscribes(s.stream().map(VersionAppEventStructMapper.MAPPER::toVersionAppEventSubscribe).collect(Collectors.toMap(e -> String.valueOf(e.getId()), Functions.identity()))));
            return versionAppEvent;
        }).collect(Collectors.toMap(o -> String.valueOf(o.getId()), Functions.identity()));
    }
}

